<?php

namespace Smply\SGUtilities\ViewHelpers;

use HDNET\Focuspoint\Service\FocusCropService;
use TYPO3\CMS\Core\Resource\FileInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Domain\Model\AbstractFileFolder;
use TYPO3\CMS\Extbase\Mvc\Web\Routing\UriBuilder;

/**
 * Class ImageViewHelper
 *
 * 1. Add Namespace {namespace sg=Smply\SGUtilities\ViewHelpers} to Templates
 * CEs from Flux etc.
 * {v:content.resources.fal(field: 'settings.image') -> v:iterator.first() -> v:variable.set(name: 'image')}
 * <sg:image treatIdAsReference="1" src="{image.id}" title="{image.title}" alt="{image.alternative}" realCrop="false"
 * divClass="{settings.imageSize}" />
 *
 * CEs from Domain Models
 * <sg:image treatIdAsReference="1" image="{slide.image}" title="{slide.image.title}" alt="{slide.image.alternative}"
 * realCrop="false" divClass="focuspoint__maxi" />
 *
 * @package Smply\SGUtilities\ViewHelpers
 */
class ImageViewHelper extends \TYPO3\CMS\Fluid\ViewHelpers\ImageViewHelper {

    /**
     * @var \TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface
     * @inject
     */
    protected $configurationManager;

    /**
     * Returns TypoSript settings array
     *
     * @param string $extension Name of the extension
     * @param string $plugin Name of the plugin
     * @return array
     */
    public function getSettings($extension = null, $plugin = null)
    {

        $typoScript = $this->configurationManager->getConfiguration(
            \TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface::CONFIGURATION_TYPE_SETTINGS,
            $extension,
            $plugin);

        return $typoScript;

    }

    /**
     * Resize a given image (if required) and renders the respective img tag
     *
     * @see http://typo3.org/documentation/document-library/references/doc_core_tsref/4.2.0/view/1/5/#id4164427
     *
     * @param string $ratio
     * @param string $divClass
     * @param bool   $realCrop
     * @param int    $pageUid
     *
     * @throws \TYPO3\CMS\Fluid\Core\ViewHelper\Exception
     * @return string Rendered tag
     */
    public function render(
        //        $src = null,
        //        $width = null,
        //        $height = null,
        //        $minWidth = null,
        //        $minHeight = null,
        //        $maxWidth = null,
        //        $maxHeight = null,
        //        $treatIdAsReference = false,
        //        $image = null,
      $ratio = '1:1',
      $divClass = '',
      //        $title = '',
      //        $alt = '',
      $realCrop = true,
      $pageUid = false
    ) {
        $src                = $this->arguments[ 'src' ];
        $width              = $this->arguments[ 'width' ];
        $height             = $this->arguments[ 'height' ];
        $minWidth           = $this->arguments[ 'minWidth' ];
        $minHeight          = $this->arguments[ 'minHeight' ];
        $maxWidth           = $this->arguments[ 'maxWidth' ];
        $maxHeight          = $this->arguments[ 'maxHeight' ];
        $treatIdAsReference = $this->arguments[ 'treatIdAsReference' ];
        $image              = $this->arguments[ 'image' ];

        if ($maxWidth == ''){
            $settings = $this->getSettings('sgutilities');
            if (is_numeric($settings['maxImageWidth'])){
                $this->arguments['maxWidth'] = $settings['maxImageWidth'];
                $maxWidth = $settings['maxImageWidth'];
            }
        }

        /** @var FocusCropService $service */
        $service = GeneralUtility::makeInstance( FocusCropService::class );
        try {
            $internalImage = $service->getViewHelperImage( $src, $image, $treatIdAsReference );
            if ( $realCrop ) {
                $src                = $service->getCroppedImageSrcByFile( $internalImage, $ratio );
                $treatIdAsReference = false;
                $image              = null;
            }
        } catch( \Exception $ex ) {
            $realCrop = true;
        }

        try {
            parent::render(
              $src,
              $width,
              $height,
              $minWidth,
              $minHeight,
              $maxWidth,
              $maxHeight,
              $treatIdAsReference,
              $image
            );
        } catch( \Exception $ex ) {
            return 'Missing image!';
        }

        if ( $realCrop ) {
            return $this->tag->render();
        }

        $alt   = $internalImage->getProperty( 'alternative' );
        $title = $internalImage->getProperty( 'title' );

        // The alt-attribute is mandatory to have valid html-code, therefore add it even if it is empty
        if ( ! empty( $this->arguments[ 'alt' ] ) ) {
            $alt = $this->arguments[ 'alt' ];
        }
        if ( ! empty( $this->arguments[ 'title' ] ) ) {
            $title = $this->arguments[ 'title' ];
        }

        // Ratio calculation
        $focusPointY = $internalImage->getProperty( 'focus_point_y' );
        $focusPointX = $internalImage->getProperty( 'focus_point_x' );

        // link
        $uri = false;
        $linkTag = '';
        $linkTagClose = '';
        if( $pageUid !== false )
        {
            /**
             * @var $uriBuilder \TYPO3\CMS\Extbase\Mvc\Web\Routing\UriBuilder
             */
            $uriBuilder = $this->controllerContext->getUriBuilder();
            $uriBuilder->reset();
            $uriBuilder->setTargetPageUid( $pageUid );
            $uri = $uriBuilder->build();

            $linkTag = '<a href="'.$uri.'">';
            $linkTagClose = '</a>';
        }

        $focusTag = '<div class="focuspoint ' . $divClass . '" data-image="' . $this->tag->getAttribute( 'src' ) . '" data-focus-x="' . ( $focusPointX / 100 ) . '" data-focus-y="' . ( $focusPointY / 100 ) . '" data-image-w="' . $this->tag->getAttribute( 'width' ) . '" data-image-h="' . $this->tag->getAttribute( 'height' ) . '">';
        $imgTag = '<img class="focuspoint-lazyload-target" title="' . $title . '" alt="' . $alt . '" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII=" />';
        $focusTagClose = '</div>';

        return $focusTag.$linkTag.$imgTag.$linkTagClose.$focusTagClose;
    }
}
