<?php
namespace Smply\SGUtilities\Util;

use TYPO3\CMS\Core\Utility\ArrayUtility;

/**
 * TCA Configuration Helper
 *
 * @package Smply\SGUtilities\Util
 */
class TcaConfig
{
    /**
     * Gets the TCA configuration for a field handling Image files.
     *
     * @param string $fieldName Name of the field to be used
     * @param array $customSettingOverride Custom field settings overriding the basics
     * @param string $allowedFileExtensions Comma list of allowed file extensions (e.g. "jpg,gif,pdf")
     * @param string $disallowedFileExtensions
     *
     * @return array
     *
     * Samples for TCA Override Definitions
     *
     * 1. Standard defined via sys_file_reference // On Special field full standard is applied
     * 'tx_siteprovider_listimage' => array(
     *   'label' => 'Bild für die Übersicht',
     *   'exclude' => 1,
     *   'config' => \Smply\SGUtilities\Util\TcaConfig::getImageFieldTCAConfig(
     *     'tx_siteprovider_listimage',
     *     array()
     *   )
     * )
     *
     * 2. Standard defined via sys_file_reference // On Special field Editor totally deactivated
     * 'tx_siteprovider_listimage' => array(
     *   'label' => 'Bild für die Übersicht',
     *   'exclude' => 1,
     *   'config' => \Smply\SGUtilities\Util\TcaConfig::getImageFieldTCAConfig(
     *     'tx_siteprovider_listimage',
     *     array(
     *       'overrideChildTca' => array(
     *         'columns' => array(
     *           'crop' => null
     *         ),
     *       )
     *     )
     *   )
     * )
     *
     * 3. Standard defined via sys_file_reference // On Special something is overwritte
     * 'tx_siteprovider_listimage' => array(
     *   'label' => 'Bild für die Übersicht',
     *   'exclude' => 1,
     *   'config' => \Smply\SGUtilities\Util\TcaConfig::getImageFieldTCAConfig(
     *     'tx_siteprovider_listimage',
     *     array(
     *       'overrideChildTca' => array(
     *         'columns' => array(
     *           'crop' => array(
     *             'config' => array(
     *               'cropVariants' => array(
     *                 'desktop' => array(
     *                   'title' => 's.g. Override'
     *                 ),
     *               )
     *             )
     *           )
     *         ),
     *       )
     *     )
     *   )
     * )
     *
     * 4. No Standard defined // Cropping only set on special field
     * 'tx_siteprovider_listimage' => array(
     *   'label' => 'Bild für die Übersicht',
     *   'exclude' => 1,
     *   'config' => \Smply\SGUtilities\Util\TcaConfig::getImageFieldTCAConfig(
     *     'tx_siteprovider_listimage',
     *     array(
     *       'overrideChildTca' => array(
     *         'columns' => array(
     *           'crop' => array(
     *             'config' => array(
     *               'type' => 'imageManipulation',
     *               'allowedExtensions' => 'jpg',
     *               'cropVariants' => [
     *                 'desktop' => [
     *                   'title' => 's.g. Desktop',
     *                   'allowedAspectRatios' => [
     *                     '3:2' => [
     *                       'title' => '3:2 Querformat',
     *                       'value' => 3 / 2,
     *                     ],
     *                   ],
     *                 ],
     *                 'mobile' => [
     *                   'title' => 's.g. Mobile',
     *                   'allowedAspectRatios' => [
     *                     '1:1' => [
     *                       'title' => '1:1 Quadrat',
     *                       'value' => 1 / 1,
     *                     ],
     *                   ],
     *                 ],
     *               ],
     *             )
     *           )
     *         )
     *       )
     *     )
     *   )
     * )
     *
     * Sample for Flexform Definition
     *
     * <settings.demoimage>
     *   <TCEforms>
     *       <exclude>1</exclude>
     *       <label>Demo Image</label>
     *       <config>
     *           <type>inline</type>
     *           <foreign_table>sys_file_reference</foreign_table>
     *           <foreign_field>uid_foreign</foreign_field>
     *           <foreign_sortby>sorting_foreign</foreign_sortby>
     *           <foreign_table_field>tablenames</foreign_table_field>
     *           <foreign_match_fields>
     *               <fieldname>demoimage</fieldname>
     *           </foreign_match_fields>
     *           <foreign_label>uid_local</foreign_label>
     *           <foreign_selector>uid_local</foreign_selector>
     *           <overrideChildTca>
     *               <columns>
     *                   <uid_local>
     *                       <config>
     *                           <appearance>
     *                               <elementBrowserType>file</elementBrowserType>
     *                               <elementBrowserAllowed>jpg</elementBrowserAllowed>
     *                           </appearance>
     *                       </config>
     *                   </uid_local>
     *               </columns>
     *               <types type="array">
     *                   <numIndex index="0" type="array">
     *                       <showitem>--palette--;LLL:EXT:lang/Resources/Private/Language/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,--palette--;;filePalette</showitem>
     *                   </numIndex>
     *                   <numIndex index="2" type="array">
     *                       <showitem>--palette--;LLL:EXT:lang/Resources/Private/Language/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,--palette--;;filePalette</showitem>
     *                   </numIndex>
     *               </types>
     *           </overrideChildTca>
     *           <appearance>
     *               <useSortable>true</useSortable>
     *               <headerThumbnail>
     *                   <field>uid_local</field>
     *                   <width>45</width>
     *                   <height>45c</height>
     *               </headerThumbnail>
     *               <enabledControls>
     *                   <info>true</info>
     *                   <new>false</new>
     *                   <dragdrop>true</dragdrop>
     *                   <sort>false</sort>
     *                   <hide>true</hide>
     *                   <delete>true</delete>
     *               </enabledControls>
     *           </appearance>
     *       </config>
     *   </TCEforms>
     * </settings.demoimage>
     *
     */
    public static function getImageFieldTCAConfig($fieldName, array $customSettingOverride = [], $allowedFileExtensions = '', $disallowedFileExtensions = ''){
        if ($allowedFileExtensions == ''){
            $allowedFileExtensions = $GLOBALS['TYPO3_CONF_VARS']['GFX']['imagefile_ext'];
        }
        $imageFieldTCAConfig = [
            'type' => 'inline',
            'foreign_table' => 'sys_file_reference',
            'foreign_field' => 'uid_foreign',
            'foreign_sortby' => 'sorting_foreign',
            'foreign_table_field' => 'tablenames',
            'foreign_match_fields' => [
                'fieldname' => $fieldName
            ],
            'foreign_label' => 'uid_local',
            'foreign_selector' => 'uid_local',
            'overrideChildTca' => [
                'columns' => [
                    'uid_local' => [
                        'config' => [
                            'appearance' => [
                                'elementBrowserType' => 'file',
                                'elementBrowserAllowed' => $allowedFileExtensions
                            ],
                        ],
                    ],
                ],
                'types' => [
                    '0' => [
                        'showitem' => '--palette--;LLL:EXT:lang/Resources/Private/Language/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,--palette--;;filePalette'
                    ],
                    \TYPO3\CMS\Core\Resource\File::FILETYPE_IMAGE => [
                        'showitem' => '--palette--;LLL:EXT:lang/Resources/Private/Language/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,--palette--;;filePalette'
                    ],
                ]
            ],
            'filter' => [
                [
                    'userFunc' => \TYPO3\CMS\Core\Resource\Filter\FileExtensionFilter::class . '->filterInlineChildren',
                    'parameters' => [
                        'allowedFileExtensions' => $allowedFileExtensions,
                        'disallowedFileExtensions' => $disallowedFileExtensions
                    ]
                ]
            ],
            'appearance' => [
                'useSortable' => true,
                'headerThumbnail' => [
                    'field' => 'uid_local',
                    'width' => '45',
                    'height' => '45c',
                ],

                'enabledControls' => [
                    'info' => true,
                    'new' => false,
                    'dragdrop' => true,
                    'sort' => false,
                    'hide' => true,
                    'delete' => true,
                ],
            ],
            'behaviour' => [
                'localizeChildrenAtParentLocalization' => true,
            ],
        ];
        ArrayUtility::mergeRecursiveWithOverrule($imageFieldTCAConfig, $customSettingOverride);
        return $imageFieldTCAConfig;
    }
}