<?php
namespace SG\SgUtilities\ViewHelpers\Google;

/**
 * Viewhelper that takes realty objects and outputs a google maps static map markers array
 * for further usage in google.staticmap viewhelper
 *
 * == Example ==
 *
 * {namespace sg=SG\SgUtilities\ViewHelpers}
 *
 * <sg:google.realtytomarker realties="{0:realty}"></sg:google.realtytomarker>
 * <sg:google.realtytomarker realties="{realties}"></sg:google.realtytomarker>
 *
 * {sg:google.realtytomarker(realties:{0:realty})}
 * {sg:google.realtytomarker(realties:{realties})}
 *
 * @package SG\SgUtilities\ViewHelpers\Google
 */
class RealtytomarkerViewHelper extends \TYPO3\CMS\Fluid\Core\ViewHelper\AbstractViewHelper
{
  /**
   * Transforms the realties into map marker arrays
   * @return array
   */
  public function render()
  {
    $r = array();
    foreach( $this->arguments['realties'] as $realty )
    {
      if( $realty instanceof \Daho\SgEstateCore\Domain\Model\Immobilie )
      {
         $lat = $realty->getObjektBreitengrad();
         $long = $realty->getObjektLaengengrad();
         if( $long && $lat )
         {
           $r[] = array('location' => "{$lat},{$long}");
         }
      }
    }
    return $r;
  }

  /**
   * Arguments Initialization
   */
  public function initializeArguments()
  {
    $this->registerArgument('realties', 'array', 'Realties to convert', array() );
  }
}