<?php

namespace Smply\SGUtilities\ViewHelpers;

use HDNET\Focuspoint\Service\FocusCropService;
use TYPO3\CMS\Core\Resource\FileInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Domain\Model\AbstractFileFolder;

/**
 * Class ImageViewHelper
 *
 * 1. Add Namespace {namespace sg=Smply\SGUtilities\ViewHelpers} to Templates
 * CEs from Flux etc.
 * {v:content.resources.fal(field: 'settings.image') -> v:iterator.first() -> v:variable.set(name: 'image')}
 * <sg:image treatIdAsReference="1" src="{image.id}" title="{image.title}" alt="{image.alternative}" realCrop="false" divClass="{settings.imageSize}" />
 *
 * CEs from Domain Models
 * <sg:image treatIdAsReference="1" image="{slide.image}" title="{slide.image.title}" alt="{slide.image.alternative}" realCrop="false" divClass="focuspoint__maxi" />
 *
 * @package Smply\SGUtilities\ViewHelpers
 */

class ImageViewHelper extends \TYPO3\CMS\Fluid\ViewHelpers\ImageViewHelper
{

    /**
     * Resize a given image (if required) and renders the respective img tag
     *
     * @see http://typo3.org/documentation/document-library/references/doc_core_tsref/4.2.0/view/1/5/#id4164427
     *
     * @param string $src a path to a file, a combined FAL identifier or an uid (integer). If $treatIdAsReference is set, the integer is considered the uid of the sys_file_reference record. If you already got a FAL object, consider using the $image parameter instead
     * @param string $width width of the image. This can be a numeric value representing the fixed width of the image in pixels. But you can also perform simple calculations by adding "m" or "c" to the value. See imgResource.width for possible options.
     * @param string $height height of the image. This can be a numeric value representing the fixed height of the image in pixels. But you can also perform simple calculations by adding "m" or "c" to the value. See imgResource.width for possible options.
     * @param integer $minWidth minimum width of the image
     * @param integer $minHeight minimum height of the image
     * @param integer $maxWidth maximum width of the image
     * @param integer $maxHeight maximum height of the image
     * @param boolean $treatIdAsReference given src argument is a sys_file_reference record
     * @param FileInterface|AbstractFileFolder $image a FAL object
     * @param string $ratio
     * @param string $divClass


     * @param bool $realCrop
     *
     * @throws \TYPO3\CMS\Fluid\Core\ViewHelper\Exception
     * @return string Rendered tag
     */
    public function render(
        $src = null,
        $width = null,
        $height = null,
        $minWidth = null,
        $minHeight = null,
        $maxWidth = null,
        $maxHeight = null,
        $treatIdAsReference = false,
        $image = null,
        $ratio = '1:1',
        $divClass = '',
//        $title = '',
//        $alt = '',
        $realCrop = true
    ) {
        /** @var FocusCropService $service */
        $service = GeneralUtility::makeInstance(FocusCropService::class);
        try {
            $internalImage = $service->getViewHelperImage($src, $image, $treatIdAsReference);
            if ($realCrop) {
                $src = $service->getCroppedImageSrcByFile($internalImage, $ratio);
                $treatIdAsReference = false;
                $image = null;
            }
        } catch (\Exception $ex) {
            $realCrop = true;
        }

        try {
            parent::render(
                $src,
                $width,
                $height,
                $minWidth,
                $minHeight,
                $maxWidth,
                $maxHeight,
                $treatIdAsReference,
                $image
            );
        } catch (\Exception $ex) {
            return 'Missing image!';
        }

        if ($realCrop) {
            return $this->tag->render();
        }

        $alt = $internalImage->getProperty('alternative');
        $title = $internalImage->getProperty('title');

        // The alt-attribute is mandatory to have valid html-code, therefore add it even if it is empty
        if ( !empty($this->arguments['alt']) )
        {
          $alt = $this->arguments['alt'];
        }
        if ( !empty($this->arguments['title']) )
        {
          $title = $this->arguments['title'];
        }

        // Ratio calculation
        $focusPointY = $internalImage->getProperty('focus_point_y');
        $focusPointX = $internalImage->getProperty('focus_point_x');

        $focusTag = '<div class="focuspoint '.$divClass.'" data-image="' . $this->tag->getAttribute('src') . '" data-focus-x="' . ($focusPointX / 100) . '" data-focus-y="' . ($focusPointY / 100) . '" data-image-w="' . $this->tag->getAttribute('width') . '" data-image-h="' . $this->tag->getAttribute('height') . '">';
        //return $focusTag . $this->tag->render() . '</div>';
      return $focusTag . '<img class="focuspoint-lazyload-target" title="'.$title.'" alt="'.$alt.'" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII=" />' . '</div>';
    }
}
