<?php
defined('TYPO3_MODE') || die();

call_user_func(function () {

    if (\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::isLoaded('lang')) {
        $generalLanguageFile = 'EXT:lang/Resources/Private/Language/locallang_general.xlf';
    } else {
        $generalLanguageFile = 'EXT:core/Resources/Private/Language/locallang_general.xlf';
    }

    $fields = array(
        'tx_sg_sitepackage_starttime' => [
            'exclude' => true,
            'label' => 'LLL:' . $generalLanguageFile . ':LGL.starttime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'eval' => 'datetime',
                'default' => 0,
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],
        'tx_sg_sitepackage_endtime' => [
            'exclude' => true,
            'label' => 'LLL:' . $generalLanguageFile . ':LGL.endtime',
            'config' => [
                'type' => 'input',
                'renderType' => 'inputDateTime',
                'eval' => 'datetime',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038),
                ],
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],
    );
    // Add new TCA fields to TCA:
    \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addTCAcolumns('sys_file_metadata', $fields);
    // Add new fields to palette
    \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addFieldsToPalette('sys_file_metadata', '10',
                '--linebreak--,tx_sg_sitepackage_starttime;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:starttime_formlabel,tx_sg_sitepackage_endtime;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:endtime_formlabel');

});
