<?php

use \TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use \TYPO3\CMS\Core\Resource\File;

defined('TYPO3_MODE') || die();

call_user_func(function() {

    // Sets the default frame_class to "section"
    // uncomment if you have a more linear layout so this default
    // makes sense
    // $GLOBALS['TCA']['tt_content']['columns']['frame_class']['config']['default'] = 'section';


    $ttContentDefaultCustomFields = array(
        'tx_sg_sitepackage_headline' => array(
            'label' => 'Überschrift',
            'config' => array(
                'type' => 'input',
                'size' => '40',
                'eval' => 'trim',
                'max' => '140',
            )
        ),
        'tx_sg_sitepackage_headline_layout' => array (
            'label' => 'Überschrift-Typ',
            'config' => array (
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => array (
                    array('Paragraph (Standard)', 'p'),
                    array('Headline H2', 'h2'),
                    array('Headline H3', 'h3'),
                    array('Headline H4', 'h4'),
                ),
                'size' => 1,
                'maxitems' => 1,
            )
        ),
        'tx_sg_sitepackage_cta' => array(
            'label' => 'Call-To-Action',
            'config' => array(
                'type' => 'input',
                'renderType' => 'inputLink',
            ),
        ),
        'tx_sg_sitepackage_cta_caption' => array(
            'label' => 'Call-To-Action Beschriftung',
            'config' => array(
                'type' => 'input',
                'size' => '40',
                'eval' => 'trim',
                'max' => '140',
            )
        ),
        'tx_sg_sitepackage_type' => array (
            'label' => 'Typ',
            'config' => array (
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => array (
                    array('Standard', ''),
                ),
                'size' => 1,
                'maxitems' => 1,
            )
        ),
        'tx_sg_sitepackage_layout' => [
            'label' => 'Typ',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['Standard', ''],
                ],
                'size' => 1,
                'maxitems' => 1,
            ]
        ],
        'tx_sg_sitepackage_content' => array(
            'label' => 'Inhalt',
            'config' => array(
                'type' => 'text',
                'cols' => '40',
                'rows' => '4',
                'enableRichtext' => true,
                'richtextConfiguration' => 'default',
            )
        ),
        'tx_sg_sitepackage_images' => array(
            'label' => 'Bilder',
            'config' => ExtensionManagementUtility::getFileFieldTCAConfig(
                'tx_sg_sitepackage_images',
                array(
                    'overrideChildTca' => array(
                        'types' => array(
                            '0' => array(
                                'showitem' => '
                            --palette--;
                                LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;
                                imageoverlayPalette,
                            --palette--;;filePalette'
                            ),
                            File::FILETYPE_TEXT => array(
                                'showitem' => '
                            --palette--;
                                LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;
                                imageoverlayPalette,
                            --palette--;;filePalette'
                            ),
                            File::FILETYPE_IMAGE => array(
                                'showitem' => '
                            --palette--;
                                LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;
                                imageoverlayPalette,
                            --palette--;;filePalette'
                            ),
                            File::FILETYPE_AUDIO => array(
                                'showitem' => '
                            --palette--;
                                LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;
                                imageoverlayPalette,
                            --palette--;;filePalette'
                            ),
                            File::FILETYPE_VIDEO => array(
                                'showitem' => '
                            --palette--;
                                LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;
                                imageoverlayPalette,
                            --palette--;;filePalette'
                            ),
                            File::FILETYPE_APPLICATION => array(
                                'showitem' => '
                            --palette--;
                                LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;
                                imageoverlayPalette,
                            --palette--;;filePalette'
                            )
                        )
                    ),
                ),
                'jpg,png'
            ),
        ),
        'tx_sg_sitepackage_relation_slide' => [
            'label' => 'Slide',
            'config' => [
                'type' => 'inline',
                'foreign_table' => 'tx_sg_sitepackage_slide',
                'foreign_field' => 'tt_content',
                'maxitems' => 9999,
                'appearance' => [
                    'useSortable' => true,
                    'collapseAll' => 0,
                    'levelLinksPosition' => 'top',
                    'showSynchronizationLink' => true,
                    'showAllLocalizationLink' => true,
                    'showPossibleLocalizationRecords' => true,
                    'showRemovedLocalizationRecords' => false,
                    'expandSingle' => true,
                    'enabledControls' => [
                        'localize' => true,
                    ]
                ],
                'behaviour' => [
                    'mode' => 'select',
                    'localizeChildrenAtParentLocalization' => true,
                ]
            ],
        ],
        'tx_sg_sitepackage_relation_card' => [
            'label' => 'Card',
            'config' => [
                'type' => 'inline',
                'foreign_table' => 'tx_sg_sitepackage_card',
                'foreign_field' => 'tt_content',
                'maxitems' => 9999,
                'appearance' => [
                    'useSortable' => true,
                    'collapseAll' => 0,
                    'levelLinksPosition' => 'top',
                    'showSynchronizationLink' => true,
                    'showAllLocalizationLink' => true,
                    'showPossibleLocalizationRecords' => true,
                    'showRemovedLocalizationRecords' => false,
                    'expandSingle' => true,
                    'enabledControls' => [
                        'localize' => true,
                    ]
                ],
                'behaviour' => [
                    'mode' => 'select',
                    'localizeChildrenAtParentLocalization' => true,
                ]
            ],
        ],
        'tx_sg_sitepackage_relation_contentpane' => [
            'label' => 'Pane',
            'config' => [
                'type' => 'inline',
                'foreign_table' => 'tx_sg_sitepackage_contentpane',
                'foreign_field' => 'tt_content',
                'maxitems' => 9999,
                'appearance' => [
                    'useSortable' => true,
                    'collapseAll' => 0,
                    'levelLinksPosition' => 'top',
                    'showSynchronizationLink' => true,
                    'showAllLocalizationLink' => true,
                    'showPossibleLocalizationRecords' => true,
                    'showRemovedLocalizationRecords' => false,
                    'expandSingle' => true,
                    'enabledControls' => [
                        'localize' => true,
                    ]
                ],
                'behaviour' => [
                    'mode' => 'select',
                    'localizeChildrenAtParentLocalization' => true,
                ]
            ],
        ],
        'tx_sg_sitepackage_relation_feature' => [
            'label' => 'Feature',
            'config' => [
                'type' => 'inline',
                'foreign_table' => 'tx_sg_sitepackage_feature',
                'foreign_field' => 'tt_content',
                'maxitems' => 9999,
                'appearance' => [
                    'useSortable' => true,
                    'collapseAll' => 1,
                    'levelLinksPosition' => 'top',
                    'showSynchronizationLink' => true,
                    'showAllLocalizationLink' => true,
                    'showPossibleLocalizationRecords' => true,
                    'showRemovedLocalizationRecords' => false,
                    'expandSingle' => true,
                    'enabledControls' => [
                        'localize' => true,
                    ]
                ],
                'behaviour' => [
                    'mode' => 'select',
                    'localizeChildrenAtParentLocalization' => true,
                ]
            ],
        ],
        'tx_sg_sitepackage_relation_contentpane_contentelements' => [
            'config' => [
                'type' => 'passthrough'
            ]
        ],
    );
    // Add new fields to pages:
    \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addTCAcolumns('tt_content', $ttContentDefaultCustomFields );

    /**
     * Custom Content Elements:
     * Include all custom content element TCA and plugin definitions
     */
    include_once('Includes/tt_content_card.php');
    include_once('Includes/tt_content_card_slider.php');
    include_once('Includes/tt_content_cta.php');
    include_once('Includes/tt_content_slider.php');
    include_once('Includes/tt_content_teaser.php');
    include_once('Includes/tt_content_accordion.php');
    include_once('Includes/tt_content_tabs.php');
    include_once('Includes/tt_content_postit.php');
    include_once('Includes/tt_content_feature_collection.php');

});
