<!-- Markdown link & img dfn's -->
[coders.care-url]: https://coders.care
[patreon-url]: https://www.patreon.com/cybercraft
[flattr-url]: https://www.flattr.com/@Cybercraft
[paypal-url]: https://www.paypal.me/cybercraftsponsoring/50
[amazon-url]: https://www.amazon.de/gp/registry/wishlist/2I80GX9ZSMYXX
[documentation-url]: https://docs.typo3.org/typo3cms/extensions/gridelements
[blog-url]: https://coders.care/blog/article/service-level-agreements-for-typo3-extensions

# Gridelements

This TYPO3 extension integrates the grid based backend layout concept known from the page module also to regular content elements - the grid elements.

## What does it do?

Besides providing structures based on multiple columns similar to table cells, grid containers can be used to group several elements into one block or to assign special behaviour like accordions or tabs and to render the child elements accordingly. And of course containers can be nested.

It offers a lot of new features like advanced drag & drop, drag in of new elements, maximum number of items, allowed content, plugin or grid types per column or real references, that improve the usability of the page and list module to speed up the daily work with the backend of TYPO3 CMS.

## Documentation

Find installation and configuration instructions and some basic examples on [docs.typo3.org][documentation-url]

## Inspiring people to share

We strongly believe in the principles of Open-source software, which is why we share this TYPO3 extension with you completely free of charge.

Still even contributors to Open-source projects have to make a living somehow, so even though you are not obliged to do so, you should consider sharing a small part of the money you might be earning with this extension in return. This way we can make sure to still provide the TYPO3 community with better extensions and services in the future.

Thanks in advance for your support. 

## How to support our efforts?

|                      |                       |
|:---------------------------|:--------------------------------|
| [![CodersCareLogo](Documentation/Images/Sponsoring/CodersCareLogo.png)][coders.care-url]              | Get yourself one of the Service Level Agreements we offer together with our fellow coders. This way you make sure Gridelements and other extensions live long and prosper and you will get a hotline with a defined response time in case of emergency.              |
| [![PatreonLogo](Documentation/Images/Sponsoring/PatreonLogo.png)][patreon-url]                  | A Service which allows you to become one of our Patrons on a monthly basis. You might even get a shout-out on twitter, get mentioned personally in the next release or even make a feature request depending on the amount you pick.                                  |
| [![FlattrLogo](Documentation/Images/Sponsoring/FlattrLogo.png)][flattr-url]                         | Pay any amount monthly on this service and it gets spread even around the people you want to support! We would be Flattr'ed to have you.                    |
| [![PaypalLogo](Documentation/Images/Sponsoring/PaypalLogo.png)][paypal-url]                       | You don't want to sponsor monthly? Don't worry you can also support us via Paypal with any desired amount you find reasonable.                        |
| [![AmazonWishlistLogo](Documentation/Images/Sponsoring/AmazonLogo.png)][amazon-url]                       | Sometimes you want to give it a personal touch. When you want to thank Joey and Petra with a nice Single Malt, you should take a look here. Slàinte mhath!                  |

## The Agreement

Excerpt from the coders.care blog post [Service Level Agreements for TYPO3 Extensions][blog-url]

![Big Orange rope pulling several colorful small ropes](Documentation/Images/Sponsoring/Why.jpg)
### Enabling companies, developers and the community to join forces and thrive
There is one particular thing, that should be different to most of the variants of service level agreements provided by other open-source projects though. Having to buy a so called "enterprise" or "professional" edition of the extensions or TYPO3 itself just to become entitled for an SLA is a No-Go, since it will create two classes in the community and contradict the principles of free software implied by the GPL.

The benefit for the people agreeing to a certain service level should be defined by reliability and responsiveness, not by getting access to something, that is unavailable for the rest of the community. So there must be an agreement to still share the improved public extensions with everybody in the community while getting a personal early or immediate access depending on the level and the priority you paid for.

For developers there is the need for another agreement: They have to accept and publish fixes and changes to their extensions up to a certain degree, so the whole pool of developers can take care of the extensions covered by the SLAs. This will avoid forks.

There are several nice side effects of these agreements. For example it would reduce the number of extensions which are maintained by a single person and therefore the risk of loss when using these extensions. Due to the four-eyes principle this would increase the quality of each extension in the approved pool and at the same time reduce the amount of "me too" extensions in the TER.

There would be a powerful team of developers backing the service levels, so it would be easy to keep the approved extensions on a level with upcoming versions of the TYPO3 core. And since this would be done in close collaboration with the TYPO3 core team and the security team, core bugs and security holes affecting extension behaviour could be fixed and published much more easily as well.
