#!/bin/bash

## Description: Install sitepackage w/ dependencies
## Usage: install [flags] [args]
## Example: "ddev install"

echo 'Howdy...'

YELLOW='\033[1;33m'
GREEN='\033[1;32m'
GRAY='\033[0;37m'
CYAN='\033[0;36m'
NC='\033[0m'

ENV_COPY=/var/www/html/.env
ENV_ORIGINAL=/var/www/html/_env
ENV_BADGE="${CYAN}[ENV]${NC}"

ENV_DDEV_gitignore=/var/www/html/public/typo3conf/.gitignore

# Create Username
USERNAME=smplyadmin$((1 + $RANDOM % 100))
# Create password
PW=$(openssl rand -base64 24)

if [ -f "$ENV_DDEV_gitignore" ]; then
    printf "$ENV_BADGE ${GRAY}$ENV_DDEV_gitignore${NC} exists and will be deleted. ${GREEN}ok.${NC}\n"
    rm $ENV_DDEV_gitignore
else
    printf "$ENV_BADGE ${GRAY}$ENV_DDEV_gitignore${NC} not there. ${GREEN}ok.${NC}\n"
fi

if [ -f "$ENV_COPY" ]; then
    printf "$ENV_BADGE ${GRAY}$ENV_COPY${NC} exists. ${GREEN}ok.${NC}\n"
else
    printf "$ENV_BADGE ${GRAY}$ENV_COPY${NC} does not exist. ${YELLOW}Copy boilerplate .env file now.${NC}\n"
    cp  $ENV_ORIGINAL $ENV_COPY
    printf "$ENV_BADGE Copied ${GRAY}$ENV_ORIGINAL${NC} to ${GRAY}$ENV_COPY${NC}. ${GREEN}ok.${NC}\n"
fi

VENDOR_DIR=/var/www/html/vendor
COMPOSER_BADGE="${CYAN}[COMPOSER]${NC}"
if [ -d "$VENDOR_DIR" ]; then
    printf "$COMPOSER_BADGE ${GRAY}$VENDOR_DIR${NC} folder exists. No need to run ${GRAY}composer install${NC}. ${GREEN}ok.${NC}\n"
else
    printf "$COMPOSER_BADGE ${GRAY}$VENDOR_DIR${NC} does no exist. ${YELLOW}Run composer install now...${NC}\n"
    cd /var/www/html
    composer install
fi

DB_BADGE="${CYAN}[DB]${NC}"
# Check for a table that should exist in your database
if ! mysql -e 'SELECT * FROM pages;' db > /dev/null; then
    printf "$DB_BADGE TYPO3 Database does not exist. ${YELLOW}Import boilerplate now...${NC}\n"
    gzip -dc /var/www/html/data/db.sql.gz | mysql db
    typo3cms install:setup --force --web-server-config=apache --site-setup-type=no --site-base-url=/
    typo3cms backend:createadmin $USERNAME $PW
    printf "Created Admin ${GREEN}$USERNAME${NC} with password ${GREEN}$PW${NC}\n\n"
else
    printf "$DB_BADGE TYPO3 Database exists. ${GREEN}ok.${NC}\n"
fi
