<?php

use \Helhum\ConfigLoader\ConfigurationLoader;
use \Helhum\ConfigLoader\Reader\PhpFileReader;
use \Helhum\ConfigLoader\Reader\EnvironmentReader;
use \TYPO3\CMS\Core\Core\Environment;

/**
 * TYPO3 Conf Vars Environment Configuration Stack
 * We let the loader load context and environment specific configuration
 * No other code must go in here!
 *
 * Only possible values are Development, Testing and Production. All other will
 * produce a TYPO3 exception
 */
$context = strtolower(Environment::getContext());

// __DIR__ returns the abs. path of the current script (AdditionalConfiguration.php)
$confDir = dirname(dirname(__DIR__)) . '/env';

// Build the configuration stack
$configLoader = new ConfigurationLoader(
    array(
        new PhpFileReader($confDir . '/default.php'),
        new PhpFileReader($confDir . '/' . $context . '.php'),
        new EnvironmentReader('TYPO3'),
        new PhpFileReader($confDir . '/override.php'),
    )
);

// Now do the actual configuration merge
try {
    $GLOBALS[ 'TYPO3_CONF_VARS' ] = array_replace_recursive(
        $GLOBALS[ 'TYPO3_CONF_VARS' ],
        $configLoader->load()
    );
} catch (\Exception $e) {
    echo $e->getMessage();
}

if ($context === 'production') {
    // Disable the deprecation log in production to save disk space and
    // prevent hosting from getting "full"
    // This line stays outside the normal context overrides in the env folder because
    // this seems to be the only way to make it work at the moment.
    // @see https://docs.typo3.org/m/typo3/reference-coreapi/master/en-us/ApiOverview/Deprecation/Index.html#disabling-deprecation-errors
    $GLOBALS['TYPO3_CONF_VARS']['LOG']['TYPO3']['CMS']['deprecations']['writerConfiguration'][\TYPO3\CMS\Core\Log\LogLevel::NOTICE] = [];
}
