<?php

use \TYPO3\CMS\Extbase\SignalSlot\Dispatcher;
use \TYPO3\CMS\Core\Utility\GeneralUtility;
use \TYPO3\CMS\Backend\Backend\ToolbarItems\SystemInformationToolbarItem;
use \SG\SgSitepackage\Backend\ToolbarItem\VersionToolbarItem;
use \TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use \SG\SgSitepackage\Hooks\PageLayoutView\ContentElementPreviewRenderer;

defined('TYPO3_MODE') || die();

/***************
 * Add default RTE configuration
 */
$GLOBALS['TYPO3_CONF_VARS']['RTE']['Presets']['sg_sitepackage'] = 'EXT:sg_sitepackage/Configuration/RTE/Default.yaml';

/**
 * Register for hook to show preview of custom tt_content element in page module
 */
$GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['cms/layout/class.tx_cms_layout.php']
    ['tt_content_drawItem']['sg_sitepackage_content_previews'] = ContentElementPreviewRenderer::class;

if (TYPO3_MODE === 'BE') {
    $signalSlotDispatcher = GeneralUtility::makeInstance( Dispatcher::class );

    /**
     * Add current version to system information toolbar
     */
    $signalSlotDispatcher->connect(
        SystemInformationToolbarItem::class,
        'getSystemInformation',
        VersionToolbarItem::class,
        'addVersionInformation'
    );

}

call_user_func(function()
{
    /**
     * Temporary variables
     */
    $extensionKey = 'sg_sitepackage';

    ExtensionManagementUtility::addPageTSConfig(
        "<INCLUDE_TYPOSCRIPT: source=\"FILE:EXT:{$extensionKey}/Configuration/PageTS/All.typoscript\">"
    );
});
