<?php

namespace SG\SgSitepackage\Frontend\DataProcessing;

use SG\SgSitepackage\Service\BacktraceService;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer;
use TYPO3\CMS\Frontend\ContentObject\DataProcessorInterface;
use TYPO3\CMS\Frontend\Resource\FileCollector;

class FilesProcessor extends \TYPO3\CMS\Frontend\DataProcessing\FilesProcessor
{
    /**
     * Process data of a record to resolve File objects to the view with slideUp functionality
     *
     * @param ContentObjectRenderer $cObj The data of the content element or page
     * @param array                 $contentObjectConfiguration The configuration of Content Object
     * @param array                 $processorConfiguration The configuration of this processor
     * @param array                 $processedData Key/value store of processed data (e.g. to be passed to a Fluid View)
     *
     * @return array the processed data as key/value store
     */
    public function process(
        ContentObjectRenderer $cObj,
        array $contentObjectConfiguration,
        array $processorConfiguration,
        array $processedData
    ) {
        if (isset($processorConfiguration[ 'if.' ]) && ! $cObj->checkIf($processorConfiguration[ 'if.' ])) {
            return $processedData;
        }

        // gather data
        /** @var FileCollector $fileCollector */
        $fileCollector = GeneralUtility::makeInstance(FileCollector::class);

        // references / relations
        if ( ! empty($processorConfiguration[ 'references.' ])) {
            $referenceConfiguration = $processorConfiguration[ 'references.' ];
            $relationField = $cObj->stdWrapValue('fieldName', $referenceConfiguration);

            // If no reference fieldName is set, there's nothing to do
            if ( ! empty($relationField)) {
                // Fetch the references of the default element
                $relationTable = $cObj->stdWrapValue('table', $referenceConfiguration, $cObj->getCurrentTable());
                if ( ! empty($relationTable)) {
                    $fileCollector->addFilesFromRelation($relationTable, $relationField, $cObj->data);
                    if ($processorConfiguration[ 'slideUp' ] == 1 && $fileCollector->count() == 0) {
                        $rootline = array_reverse(explode(',',
                            BacktraceService::getPageBacktraceTreeList($cObj->data[ 'pid' ])));
                        foreach ($rootline as $pageId) {
                            $fileCollector->addFilesFromRelation($relationTable, $relationField,
                                array('uid' => $pageId));
                            if ($fileCollector->count() > 0) {
                                break;
                            }
                        }
                    }
                }
            }
        }

        // files
        $files = $cObj->stdWrapValue('files', $processorConfiguration);
        if ($files) {
            $files = GeneralUtility::intExplode(',', $files, true);
            $fileCollector->addFiles($files);
        }

        // collections
        $collections = $cObj->stdWrapValue('collections', $processorConfiguration);
        if ( ! empty($collections)) {
            $collections = GeneralUtility::trimExplode(',', $collections, true);
            $fileCollector->addFilesFromFileCollections($collections);
        }

        // folders
        $folders = $cObj->stdWrapValue('folders', $processorConfiguration);
        if ( ! empty($folders)) {
            $folders = GeneralUtility::trimExplode(',', $folders, true);
            $fileCollector->addFilesFromFolders($folders,
                ! empty($processorConfiguration[ 'folders.' ][ 'recursive' ]));
        }

        // make sure to sort the files
        $sortingProperty = $cObj->stdWrapValue('sorting', $processorConfiguration);
        if ($sortingProperty) {
            $sortingDirection = $cObj->stdWrapValue(
                'direction',
                $processorConfiguration[ 'sorting.' ] ?? [],
                'ascending'
            );

            $fileCollector->sort($sortingProperty, $sortingDirection);
        }

        // set the files into a variable, default "files"
        $targetVariableName = $cObj->stdWrapValue('as', $processorConfiguration, 'files');
        $processedData[ $targetVariableName ] = $fileCollector->getFiles();

        return $processedData;
    }
}