# smply.gd TYPO3 Sitepackage

The following chapters cover how to interact with the package, 
the main idea behind certain aspects and the overall standards and 
conventions that we introduced.

The Sitepackage is only suitable for TYPO3 websites of version 9 and above. 
The master branch always targets the most up-to-date TYPO3 version. please see 
the legacy branches for older versions.

For information on version changes please see [our changelog](CHANGELOG.md).

**This document is WIP and will be extended.**

## General idea and workflow

We use a workflow based on extensions that deliver backend functionality, 
models and services and a template extension that covers the whole visual
appearance of the website, the `sg_sitepackage` extension. 
That means, every visual aspect of the website and all custom content 
elements should live in the Sitepackage.

Additional functionality e.g. a contact datasets with plugin etc. should
live in its own extension. General extensions that have a high probability
to be reused in other projects (e.g. our estate extension) will be 
moved to their own repository and will be included in the website 
via a composer dependency. More on that later.

Additional functionality that is bound to the projects scope and it is
not likely we will use that again in other projects, may also live in
their own extension, but inside the projects main repository like
the Sitepackage extension. The naming convention for all extensions
is `sg_what_the_extension_is_about` and the Namespace needs to be
`\SG\WhatTheExtensionIsAbout\...`.

## Git workflow

We use [Gitflow](https://nvie.com/posts/a-successful-git-branching-model/)
as our git branching model. Please stick to this convention.
In combination with our deployment, every push to the `develop` branch
triggers a deployment to the staging environment and every push to the
`master` branch automatically triggers a deployment to the production / 
live environment. `feature` and `release` branches do not trigger any deployments.

We use [semantic versioning](https://semver.org/).

### Commit messages

We write commit messages in english and in present tense. E.g.: 
- Adds tooltip ad placeholders
- Improves card styles

#### Prefixes

Our commit messages begin with a prefix to declare what kind of change
the commit introduces:

- **[FIX]** for a commit the solves a bug or fixes something broken
- **[FEATURE]** for a commit that adds new functionality or improves an existing
functionality
- **[REFACTOR]** for a commit that does cleanup work, introduces strctural changes,
formatting etc.
- **[DOC]** for a commit that adds or improves documentation or comments that
serve as documentation
- **[REMOVAL]** for a commit that just removes something
- **[TASK]** for all other commits
- **[VERSION]** for a commit that raises a version number

##### Examples

- [FEATURE] Adds matchHeight js lib and helper module
- [REFACTOR] Removes commented code in xxx
- [TASK] Updates TYPO3 to version 9.5.11
- [VERSION] Bumps version to 1.0.0

#### Tickets

Wherever possible we add a ticket reference to our commit messages. We add the reference in
the second line of the commit (we do not need the ticket number in the main message).
When the connection between Gitlab and Jira is setup correctly, Gitlab will
automatically mention the commit in the ticket for you.

- Solves SGDEV-143
- Contributes to LVQ154-144

#### Reference

- [Mention issues](https://gist.github.com/digitaljhelms/3761873#commit-messages )
- [Mention commits in Jira via Gitlab](https://docs.gitlab.com/ee/user/project/integrations/jira.html#closing-jira-issues )
- [Refactor prefix](https://github.com/commitizen/cz-cli )

## Installation and deployment
See [our confluence entry "Create new TYPO3 v9 project"](https://smplygd.atlassian.net/wiki/spaces/SG/pages/523272193/Create+new+TYPO3+v9+Project) 
for further guidance to install the package with the TYPO3 distribution and enable 
deployment on staging/production hosts.

## Installation of asset building in sitepackage extension
We use node (npm), the sass compiler and gulp in order to build our resources.
To be able to build the needed css and js resources you need to install
the following pieces of software on your machine (one time installation):

1. [Node.js with npm](https://nodejs.org/en/download/) (mind. Node 10.15.3, npm 6.4.1)
2. [Gulp](https://gulpjs.com/) as global modul `npm install -g gulp-cli`, to be able
use the `gulp` command in your project folder
3. [Install Sass](http://sass-lang.com/install). Via Terminal on Mac. 
On Windows you need to install Ruby (mind. 2.5.x) first. After that you can use the Ruby package 
manager `gem` to install SASS (mind. 3.7.4, `gem install sass`).

## Setup your Sitepackage extension

After you have installed all necessary pieces of software it is time to setup
our resources and assets. This needs to be done everytime you install a new
TYPO3 distribution with the Sitepackage extension (first install).

1. Go to your sitepackage's `Public` folder.
2. Run `npm install` to install all default packages.
3. Run `gulp build` to build your assets and js/css dist resources.
4. In development you can just run `gulp`. The default task integrated a watch 
task on all assets in Css/Js folder so you do not need to run `gulp build` everytime
you change a line of code.

After you are ready to go, feel free to add npm packages that you need for the 
current project via `npm install xxx --save` or update certain dependencies that
you need in a certain version.

Please keep in mind that this is a streamlined process we use in every project,
so the base set should stay as is:
- bootstrap 4
- jQuery v3 (wherever possible, we know there are some libs that conflict 
with version 3, so the integrated version 2 latest to be sure. Update to version 3
where it is possible)
- gulp 4

## Built-in features in Sitepackage

### Start and stop dates for files and documents

*(since 0.12.0)* The Sitepackage introduces start and stop date fields for `sys_file_metadata`, 
so you can specify when a given file is valid or should be visible. To make this work,
we also added a new `FilesProcessor` called `StartStopFilesProcessor`. You can use
this processor whenever you need to process files in a content element or a model.

```typo3_typoscript
dataProcessing {
    10 = SG\SgSitepackage\Frontend\DataProcessing\StartStopFilesProcessor
    10 {
        # Where are the files located (if you don't use collections, default files field)
        references.fieldName = media
        # What is the collections field (if you use collections)
        collections.field = file_collections
        # Some sorting overrides. Adjust to your needs
        sorting.field = filelink_sorting
        sorting.direction.field = filelink_sorting_direction
    }
}
```

We also added a default configuration for `fluid_styled_content` CE `uploads`. You
can find this override configuration in `Configuration/TypoScript/Extensions/fluid_styled_content/setup.typoscript` 
which is included in our base static. So by default all data which will be delivered by the 
default `uploads` CE will be processed by our `StartStopFilesProcessor`.

## Setting up your TYPO3 instance

## Philosophy of layout editing and maintainability

We would like to stick to core methods as close as possible. 
That's why we dropped support for `fluidpages` and `fluidcontent` in favor
of core content elements. To realize grids (rows with columns) we use
the Gridelements extension with elements from one to four columns. 

We use Gridelements *only* for grids (rows with cols), all other elements
should be solved with custom content elements (e.g. cards, slider etc).

## Working with custom Content Elements

We added our own set of `tt_content` table fields that should cover most 
scenarios. If you feel the need of adding another field, you may do so.
In our TCA for the `tt_content` table we defined a base / default configuration
that maybe overridden by your custom content elements TCA overrides.

Actually there are several places where you need to modify code in order to
add a new content element (CE) or modify an existing one:

- PageTS new content wizard typoscript
- TCA definition for `tt_content`. Add a new plugin for your new type
and add TCA table configuration for this type (`showitem` and `columnsOverrides`).
- Add a new icon for the CE new content wizard in `ext_localconf.php` and the
corresponding PNG file in `Resources/Public/Icons/ContentElements/`.
- Add the typoscript definition for the FE fluid template for your CE
- Add the CE fluid template
- Add the CE fluid template for the backend preview

## Connection to auth.smply.gd

Please do the following steps to connect the installation to the authentication server.

- Create a new T3AM Client on https://auth.smply.gd/typo3/ (Use the project as the titel, this Client will be used for all instances of this project, dev, stage & production)
- Copy the token and insert it in the configuration of t3am client in this project here
- Server URL is https://auth.smply.gd/
- Please add a new folder /fileadmin/avatars on all instances
- Insert in the t3am client configuration "1:/avatars/" to activate the avatar sync 

## Get Content from external systems

With the command `ddev getcontent` it is possible to sync content (database & files) from an external system to your ddev environment.

- You need to add your public ssh key to the external system so that a connection with ssh & pubkey is possible.
- run `ddev auth ssh`
- Edit `.ddev/docker-compose.getcontent.yml` to your needs and `ddev restart`
- run `ddev getcontent` to sync the contents
- you can specify the user, host & path via cli arguments (--sshUser, --host, --typo3root)
- with the argument --skipfileadmin the files from fileadmin dir will not be synced
- with the argument --skipuploads the files from uploads dir will not be synced 
