// By default, Klaro will load the config from  a global "klaroConfig" variable.
// You can change this by specifying the "data-config" attribute on your
// script take, e.g. like this:
// <script src="klaro.js" data-config="myConfigVariableName" />
// You can also disable auto-loading of the consent notice by adding
// data-no-auto-load=true to the script tag.
var klaroConfig = {
    // You can customize the ID of the DIV element that Klaro will create
    // when starting up. If undefined, Klaro will use 'klaro'.
    elementID: 'klaro',

    // You can customize the name of the cookie that Klaro uses for storing
    // user consent decisions. If undefined, Klaro will use 'klaro'.
    cookieName: 'klaro',

    // You can also set a custom expiration time for the Klaro cookie.
    // By default, it will expire after 120 days.
    cookieExpiresAfterDays: 365,

    // You can change to cookie domain for the consent manager itself.
    // Use this if you want to get consent once for multiple matching domains.
    // If undefined, Klaro will use the current domain.
    //cookieDomain: '.github.com',

    // Put a link to your privacy policy here (relative or absolute).
    privacyPolicy: window.SGSitepackagePrivacyUrl,

    // Defines the default state for applications (true=enabled by default).
    default: false,

    // If "mustConsent" is set to true, Klaro will directly display the consent
    // manager modal and not allow the user to close it before having actively
    // consented or declines the use of third-party apps.
    mustConsent: window.SGSitepackageMustConsent,

    // You can define the UI language directly here. If undefined, Klaro will
    // use the value given in the global "lang" variable. If that does
    // not exist, it will use the value given in the "lang" attribute of your
    // HTML tag. If that also doesn't exist, it will use 'en'.
    //lang: 'en',

    // You can overwrite existing translations and add translations for your
    // app descriptions and purposes. See `src/translations/` for a full
    // list of translations that can be overwritten:
    // https://github.com/KIProtect/klaro/tree/master/src/translations

    // Example config that shows how to overwrite translations:
    // https://github.com/KIProtect/klaro/blob/master/src/configs/i18n.js
    translations: {
        // If you erase the "consentModal" translations, Klaro will use the
        // bundled translations.
        de: {
            consentModal: {
                title: 'Cookie-Einstellungen',
                description:
                    'Wir verwenden Cookies, um Inhalte und Anzeigen zu personalisieren und die Zugriffe auf unsere Website zu analysieren. Außerdem geben wir Informationen zu Ihrer Verwendung unserer Website an unsere Partner für soziale Medien, Werbung und Analysen weiter. Sie akzeptieren unsere Cookies, wenn Sie fortfahren diese Webseite zu nutzen.',
            },
            // googleMaps: {
            //     description: 'Kartendarstellung von Google gehostet',
            // },
            googleAnalytics:{
                description: 'Externes Tracking Tool'
            },
            purposes: {
                analytics: 'Besucher-Statistiken',
                security: 'Sicherheit',
                livechat: 'Live Chat',
                advertising: 'Anzeigen von Werbung',
                styling: 'Styling',
                comfort: 'Komfort'
            },
        },
        en: {
            consentModal: {
                title:'Cookie-Settings',
                description:
                    'We use cookies and other tracking technologies to personalize and improve your experience. By continuing to use our website you consent to this.',
            },
            // googleMaps: {
            //     description: 'Maps hosted by Google',
            // },
            googleAnalytics:{
                description: 'External Tracking Tool'
            },
            purposes: {
                analytics: 'Analytics',
                security: 'Security',
                livechat: 'Livechat',
                advertising: 'Advertising',
                styling: 'Styling',
                comfort: 'Comfort'
            },
        },
    },

    // This is a list of third-party apps that Klaro will manage for you.
    apps: [
        {
            name: 'googleAnalytics',
            title: 'Google Analytics',
            purposes: ['analytics'],
            cookies : [/^ga/i],
            callback: function (consent, app) {
                if (consent){
                    window.SGGoogleAnalytics.init({ debug: false });
                }
            }
        }
        // {
        //     name: 'googleMaps',
        //     title: 'Google Maps',
        //     purposes: ['styling','comfort'],
        //     cookies : [
        //         'OGPC',
        //         'NID',
        //         'CONSENT',
        //         'ANID',
        //         '1P_JAR'
        //     ],
        //     callback: function (consent, app) {
        //         if (!consent && window.googleMapsConsent == true){
        //             window.googleMapsConsent = false;
        //             window.location.reload();
        //         }else{
        //             window.googleMapsConsent = true;
        //         }
        //     }
        // }
    ],
};
