#!/bin/bash

## Description: get content from external system
## Usage: getcontent [flags] [args]
## Example: "ddev getcontent --skipfiladmin --skipuploads --sshUser=aaa --host=bbb --port=22 --typo3root=/zz/zz/"

sshUser=$GETCONTENT_SSHUSER
host=$GETCONTENT_HOST
port=$GETCONTENT_PORT
typo3root=$GETCONTENT_TYPO3ROOT
skipfiladmin=false
skipuploads=false

while [ $# -gt 0 ]; do
  case "$1" in
    --sshUser=*)
      sshUser="${1#*=}"
      ;;
    --host=*)
      host="${1#*=}"
      ;;
    --typo3root=*)
      typo3root="${1#*=}"
      ;;
    --skipfileadmin*)
      skipfileadmin=true
      ;;
    --skipuploads*)
      skipuploads=true
      ;;
    *)
      printf "***************************\n"
      printf "* Error: Invalid argument.*\n"
      printf "***************************\n"
      exit 1
  esac
  shift
done

# Sync Database to ddev Environment
echo "Sync Database"
ssh "$sshUser"@"$host" -p $port "$typo3root/current/vendor/bin/typo3cms database:export -e 'cache_*' -e 'cf_*'" | /var/www/html/vendor/bin/typo3cms database:import

# Sync Fileadmin to ddev Environment
if [ $skipfiladmin = "false" ]
then
  echo "Sync Fileadmin"
  echo "Pfad $typo3root"
  rsync -avz --delete --exclude="_processed_" --exclude="_temp_" -e "ssh -p $port" "$sshUser"@"$host":"$typo3root/shared/public/fileadmin/" "/var/www/html/public/fileadmin/"
fi

# Sync Uploads to ddev Environment
if [ $skipuploads = "false" ]
then
  echo "Sync Uploads"
  echo "Pfad $typo3root"
  rsync -avz --delete --exclude="archiv/*" -e "ssh -p $port" "$sshUser"@"$host":"$typo3root/shared/public/uploads/" "/var/www/html/public/uploads/"
fi

echo "Flush cache"
/var/www/html/vendor/bin/typo3cms cache:flush