<?php

use \TYPO3\CMS\Core\Utility\GeneralUtility;
use \TYPO3\CMS\Core\Imaging\IconRegistry;
use \TYPO3\CMS\Core\Imaging\IconProvider\BitmapIconProvider;
use \TYPO3\CMS\Core\Imaging\IconProvider\SvgIconProvider;
use \TYPO3\CMS\Core\Utility\ExtensionManagementUtility;

defined('TYPO3_MODE') || die();

call_user_func(function()
{

    /**
     * Adds backend styles. Looks for css files in the given folder
     * and includes all of them
     */
    $GLOBALS['TBE_STYLES']['skins']['sg_sitepackage'] = array (
        'name' => 'sg_sitepackage',
        'stylesheetDirectories' => array(
            'css' => 'EXT:sg_sitepackage/Resources/Public/Dist/Css/Backend/'
        )
    );

    /**
     * Register all neccessary icons
     */

    $iconRegistry = GeneralUtility::makeInstance(
        IconRegistry::class
    );

    /**
     * CE Card Icon
     */
    $iconRegistry->registerIcon(
        'sg_sitepackage_models_card_icon', // Icon-Identifier
        BitmapIconProvider::class,
        ['source' => 'EXT:sg_sitepackage/Resources/Public/Icons/InlineModels/sg_sitepackage_card.png']
    );

    /**
     * CE Slide Icon
     */
    $iconRegistry->registerIcon(
        'sg_sitepackage_models_slide_icon', // Icon-Identifier
        BitmapIconProvider::class,
        ['source' => 'EXT:sg_sitepackage/Resources/Public/Icons/InlineModels/sg_sitepackage_slide.png']
    );

    /**
     * CE Slider Icon
     */
    $iconRegistry->registerIcon(
        'sg_sitepackage_slider_icon', // Icon-Identifier
        BitmapIconProvider::class,
        ['source' => 'EXT:sg_sitepackage/Resources/Public/Icons/ContentElements/sg_sitepackage_slider.png']
    );

    /**
     * CE Card-Slider Icon
     */
    $iconRegistry->registerIcon(
        'sg_sitepackage_card_slider_icon', // Icon-Identifier
        BitmapIconProvider::class,
        ['source' => 'EXT:sg_sitepackage/Resources/Public/Icons/ContentElements/sg_sitepackage_card_slider.png']
    );

    /**
     * CE Card Icon
     */
    $iconRegistry->registerIcon(
        'sg_sitepackage_card_icon', // Icon-Identifier
        BitmapIconProvider::class,
        ['source' => 'EXT:sg_sitepackage/Resources/Public/Icons/ContentElements/sg_sitepackage_card.png']
    );

    /**
     * CE Teaser Icon
     */
    $iconRegistry->registerIcon(
        'sg_sitepackage_teaser_icon', // Icon-Identifier
        BitmapIconProvider::class,
        ['source' => 'EXT:sg_sitepackage/Resources/Public/Icons/ContentElements/sg_sitepackage_teaser.png']
    );

    /**
     * CE CTA Icon
     */
    $iconRegistry->registerIcon(
        'sg_sitepackage_cta_icon', // Icon-Identifier
        BitmapIconProvider::class,
        ['source' => 'EXT:sg_sitepackage/Resources/Public/Icons/ContentElements/sg_sitepackage_cta.png']
    );

    /**
     * SysInformation icon
     */
    $iconRegistry->registerIcon(
        'sg_sitepackage_systeminformation', // Icon-Identifier
        SvgIconProvider::class,
        ['source' => 'EXT:sg_sitepackage/Resources/Public/Icons/sg_sitepackage_systeminformation.svg']
    );

    /**
     * CE Accordion Icon
     */
    $iconRegistry->registerIcon(
        'sg_sitepackage_accordion_icon', // Icon-Identifier
        BitmapIconProvider::class,
        ['source' => 'EXT:sg_sitepackage/Resources/Public/Icons/ContentElements/sg_sitepackage_accordion.png']
    );

    /**
     * CE ContentPane Icon
     */
    $iconRegistry->registerIcon(
        'sg_sitepackage_models_contentpane_icon', // Icon-Identifier
        BitmapIconProvider::class,
        ['source' => 'EXT:sg_sitepackage/Resources/Public/Icons/InlineModels/sg_sitepackage_contentpane.png']
    );

    /**
     * CE Tabs Icon
     */
    $iconRegistry->registerIcon(
        'sg_sitepackage_tabs_icon', // Icon-Identifier
        BitmapIconProvider::class,
        ['source' => 'EXT:sg_sitepackage/Resources/Public/Icons/ContentElements/sg_sitepackage_tabs.png']
    );

    ExtensionManagementUtility::allowTableOnStandardPages('tx_sg_sitepackage_card');
    ExtensionManagementUtility::allowTableOnStandardPages('tx_sg_sitepackage_slide');
    ExtensionManagementUtility::allowTableOnStandardPages('tx_sg_sitepackage_contentpane');
});
