/**
 * Inits the bx slider module w/ some crazy cool config classes
 * 
 * Use the folling classes to trigger functionality on .bxslider element:
 * -  .bxslider-controls 
 *     to enable controls. w/o this class no controls will be visible
 *     Controls will be hidden always if the slider only contains one element.
 *     
 * -  .bxslider-noauto 
 *     to disable autostart. W/o this class the slider has autostart
 */
( function( window, document ) {

  if( $('.bxslider').length > 0 )
  {
    var $slider = $('.bxslider');
    var enableControls = false;
    if( $slider.hasClass("bxslider-controls") )
    {
      enableControls = true;
    }

    var enableAutostart = true;
    if( $slider.hasClass("bxslider-noauto") )
    {
      enableAutostart = false;
    }

    var enableAdaptiveHeight = false;
    if( $slider.hasClass("bxslider-adaptiveheight") )
    {
      enableAdaptiveHeight = true;
    }

    var nextSelector = false;
    var prevSelector = false;
    if( $slider.data("next-selector") )
    {
      nextSelector = $slider.data("next-selector");
    }
    if( $slider.data("prev-selector") )
    {
      prevSelector = $slider.data("prev-selector");
    }

    var nextText = "Next";
    if( $slider.data("next-text") )
    {
      nextText = $slider.data("next-text");
    }
    var prevText = "Prev";
    if( $slider.data("prev-text") )
    {
      prevText = $slider.data("prev-text");
    }

    $slider = $('.bxslider').bxSlider({
      auto:enableAutostart, 
      adaptiveHeight: enableAdaptiveHeight, 
      controls: enableControls, 
      preloadImages: 'visible',
      nextText: nextText,
      prevText: prevText
    });

    if( nextSelector )
    {
      $(".bx-wrapper .bx-next").addClass( nextSelector );
    }
    if( prevSelector )
    {
      $(".bx-wrapper .bx-prev").addClass( prevSelector );
    }

    if( $slider && $slider.length > 0 )
    {
      // Remove paging elements, if slidecount is one or less
      if( $slider.getSlideCount() <= 1 )
      {
        $('.bx-controls').addClass('bx-controls-hide');
      }
    }
  }

})( window, document );