# SG Sitepackage Extension

## Installation

Voraussetzungen lokal: npm, gulp-cli, gulp, sass.

### Einrichtung

1. [Node.js mit npm installieren](https://nodejs.org/en/download/)
2. [Gulp](https://gulpjs.com/) als globales Modul installieren `npm install -g gulp-cli`
3. [SASS installieren](http://sass-lang.com/install). Via Terminal auf dem Mac. Auf Windows muss zunächst Ruby installiert werden. Danach kann über den Ruby-Paketmanager `gem` SASS installiert werden.

### Build Prozess
Das Entwicklungsverzeichnis für unser Template ist *SITE_ROOT/typo3conf/ext/sg_sitepackage/Resources/Public/*. Alle folgend genannten Befehle 
müssen im Entwicklungsverzeichnis ausgeführt werden, da sowohl *npm* als auch *gulp* projektweise in dem Ordner laufen, in dem sie aufgerufen werden. 
Verwenden wir also für zwei Projekte zwei Forks des site-providers, so sind die Installationen von *npm* und *gulp* jeweils vollkommen unabhängig voneinander.
1. `cd SITE_ROOT/typo3conf/ext/sg_sitepackage/Resources/Public/`
2. `npm install`, um alle Node-Module und Frontendmodule zu installieren, die im Build-Prozess benötigt werden.
3. `gulp`, um den Build-Prozess zu starten, alle Build-Dateien zu erzeugen und einen Watchtask für Änderungen an SCSS und JS zu registrieren. `gulp build`, um nur die Build-Dateien zu erzeugen, ohne Watchtask.

Nach einmaliger Installation kann der Build-Prozess allein mit `gulp` gestartet werden.

### Typo3

Die `sg_sitepackage` Extension benötigt folgende Extensions, um vollständig funktionsfähig zu sein:
* gridelements

Diese wird über die Composer-Installation automatisch mit installiert und sollte im weiteren Verlauf
über die Console oder über den Extensionmanager installiert werden.

#### Bespiel für eingebundene Static-Templates:
Das Static Template der Provider Extension sollte immer als letztes eingebunden werden.

1. Form
6. Content Elements (fluid_styled_content)
7. gridelements
9. SG Sitepackage Extension (include last) (sg_sitepackage)

#### Konstanten setzen
Im Konstanteneditor für die Kategorie `PLUGIN.SG_SITEPACKAGE.PIDS` die benötigten PageUids einsetzen.

Weiterhin können unter der Kategorie `PLUGIN.SG_SITEPACKAGE.KEYS` Konstanten für 
Google Analytics, Tag Manager und Site Verification gesetzt werden. Die entsprechenden Javascript-Einträge
werden automatisch über das Typoscript in die Seite eingesetzt, sofern nichts verändert wurde.
Google Analytics wird mit dem Javascript-Modul SGGoogleAnalytics gehändelt.

#### Backend-Static (Page TS)
Das Page-TS wird automatisch eingebunden, wenn die Sitepackage Extension installiert ist

#### Base URL
Die Base-URL sollte im Setup des Templates gesetzt werden. 
Falls es überschreibende Templates gibt, kann dort auch die Standard Base-URL überschrieben werden.
`config.baseURL = http://whatever.de`

## Konfiguration der Frontend-Module
Es gibt zwei Wege für das Einbinden von Frontend-Modulen: Entweder werden diese via **npm** aus einem Repository 
hinzugefügt oder sie sind bereits enthalten.

Hier eine Liste aller verfügbaren Module und Erweiterungen:
* Focuspoint
* Focuspoint Lazyloading
* BX Slider 4
* BX Slider Helper
* Match Height
* EnergyEfficiency
* SGOverlays
* SGESlider
* SGEMultiselect
* SGEFilter
* SGELiveFilter
* SGEMaps
* SGShadow
* SGOverlays
* SGFullpageMenu
* SGReplaceBrokenImages
* SGGoogleAnalytics
* Timtilch Lightbox
* Popper.js
* Bootstrap4
* Bootstrap Multiselect (für SGEMultiselect)
* JQuery UI (für SGESlider)
* JQuery UI Touch Punch (für SGESlider)
* Isotope (für SGEFilter)
* ImagesLoaded

### Focuspoint

- **Standardmäßig aktiv.** Kein Ergänzen nötig.
- Build-Prozess: *Javascript* wird via *gulp-task* automatisch integriert. CSS wird über *gulp-task* in *css/02-includes/_jquery-focuspoint.scss* kopiert. 
    SCSS wird standardmäßig in *global.scss* eingebunden mit *01-settings/_jquery-focuspoint-variables.scss* und *04-overrides/_jquery-focuspoint-overrides.scss*.
- Helper: Siehe *Focuspoint Lazyloading / window.SGFocuspoint*.

### Focuspoint Lazyloading

- **Standardmäßig aktiv.** Keine Ergänzung nötig.
- Build-Prozess: `libs/js-focuspoint-lazyloading.js` wird automatisch eingebunden. 
- Verwendung: Über Data-Attribute kann dem Fokuspoint-Container der Bildlink übergeben werden `data-image="../foo.jpg"`. 
    Im Inneren des Focuspoint-Containers muss ein Bild hinterlegt sein. Als *src* kann auch ein Platzhalterbild hinterlegt sein, wie z.B.:
    `<img class="focuspoint-lazyload-target" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mO8cf/hfwAIyAOZL7Hz4wAAAABJRU5ErkJggg==" />`
    Ist kein Data-Attribut hinterlegt, wird Focuspoint normal ausgeführt.

### BX Slider Helper

- Verwendung: Startet alle Vorkommen vom BX-Slider automatisch. Über Data-Attribute und Klassen, kann das Verhalten vom BX-Slider gesteuert werden. Siehe `sg-bxslider-helper.js`

### Match Height

- Build-Prozess: Wird automatisch eingebunden.
- Aktivieren: In `main.js` auf gewünschtes Element auslösen. Bei uns zumeist bei `.card` Elementen 
	mit `$('.match-height .card-content').matchHeight();`


## Contribution

### Versionsnummern
Versionsnummern sind zu ändern in folgenden Dateien:
- `ext_emconf.php`
