<?php
defined('TYPO3_MODE') || die();

call_user_func(function() {

    // Sets the default frame_class to "section"
    // uncomment if you have a more linear layout so this default
    // makes sense
    // $GLOBALS['TCA']['tt_content']['columns']['frame_class']['config']['default'] = 'section';


    $ttContentDefaultCustomFields = array(
        'tx_sg_sitepackage_headline' => array(
            'label' => 'Überschrift',
            'config' => array(
                'type' => 'input',
                'size' => '40',
                'eval' => 'trim',
                'max' => '140',
            )
        ),
        'tx_sg_sitepackage_cta' => array(
            'label' => 'Call-To-Action',
            'config' => array(
                'type' => 'input',
                'renderType' => 'inputLink',
            ),
        ),
        'tx_sg_sitepackage_cta_caption' => array(
            'label' => 'Call-To-Action Beschriftung',
            'config' => array(
                'type' => 'input',
                'size' => '40',
                'eval' => 'trim',
                'max' => '140',
            )
        ),
        'tx_sg_sitepackage_type' => array (
            'label' => 'Typ',
            'config' => array (
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => array (
                    array('Standard', ''),
                ),
                'size' => 1,
                'maxitems' => 1,
            )
        ),
        'tx_sg_sitepackage_content' => array(
            'label' => 'Inhalt',
            'config' => array(
                'type' => 'text',
                'cols' => '40',
                'rows' => '4',
                'enableRichtext' => true,
                'richtextConfiguration' => 'default',
            )
        ),
        'tx_sg_sitepackage_images' => array(
            'label' => 'Bilder',
            'config' => \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::getFileFieldTCAConfig(
                'tx_sg_sitepackage_images',
                array(
                    'overrideChildTca' => array(
                        'types' => array(
                            '0' => array(
                                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
                            ),
                            \TYPO3\CMS\Core\Resource\File::FILETYPE_TEXT => array(
                                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
                            ),
                            \TYPO3\CMS\Core\Resource\File::FILETYPE_IMAGE => array(
                                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
                            ),
                            \TYPO3\CMS\Core\Resource\File::FILETYPE_AUDIO => array(
                                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
                            ),
                            \TYPO3\CMS\Core\Resource\File::FILETYPE_VIDEO => array(
                                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
                            ),
                            \TYPO3\CMS\Core\Resource\File::FILETYPE_APPLICATION => array(
                                'showitem' => '
                            --palette--;LLL:EXT:lang/locallang_tca.xlf:sys_file_reference.imageoverlayPalette;imageoverlayPalette,
                            --palette--;;filePalette'
                            )
                        )
                    ),
                ),
                'jpg,png'
            ),
        ),
        'tx_sg_sitepackage_relation_slide' => [
            'label' => 'Slide',
            'config' => [
                'type' => 'inline',
                'foreign_table' => 'tx_sg_sitepackage_slide',
                'foreign_field' => 'tt_content',
                'maxitems' => 9999,
                'appearance' => [
                    'useSortable' => true,
                    'collapseAll' => 0,
                    'levelLinksPosition' => 'top',
                    'showSynchronizationLink' => true,
                    'showAllLocalizationLink' => true,
                    'showPossibleLocalizationRecords' => true,
                    'showRemovedLocalizationRecords' => false,
                    'expandSingle' => true,
                    'enabledControls' => [
                        'localize' => true,
                    ]
                ],
                'behaviour' => [
                    'mode' => 'select',
                    'localizeChildrenAtParentLocalization' => true,
                ]
            ],
        ],
        'tx_sg_sitepackage_relation_card' => [
            'label' => 'Card',
            'config' => [
                'type' => 'inline',
                'foreign_table' => 'tx_sg_sitepackage_card',
                'foreign_field' => 'tt_content',
                'maxitems' => 9999,
                'appearance' => [
                    'useSortable' => true,
                    'collapseAll' => 0,
                    'levelLinksPosition' => 'top',
                    'showSynchronizationLink' => true,
                    'showAllLocalizationLink' => true,
                    'showPossibleLocalizationRecords' => true,
                    'showRemovedLocalizationRecords' => false,
                    'expandSingle' => true,
                    'enabledControls' => [
                        'localize' => true,
                    ]
                ],
                'behaviour' => [
                    'mode' => 'select',
                    'localizeChildrenAtParentLocalization' => true,
                ]
            ],
        ],
    );
    // Add new fields to pages:
    \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addTCAcolumns('tt_content', $ttContentDefaultCustomFields );

    /**
     * Custom Content Elements
     */


    // Adds the content element to the "Type" dropdown
    \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addPlugin(
        array(
            'Slider',
            'sg_sitepackage_slider',
            'EXT:sg_sitepackage/Resources/Public/Icons/ContentElements/sg_sitepackage_slider.png'
        ),
        'CType',
        'sg_sitepackage'
    );
    // Configure the default backend fields for the content element
    $GLOBALS['TCA']['tt_content']['types']['sg_sitepackage_slider'] = array(
        'showitem' => '
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:general,
             --palette--;;general,
             tx_sg_sitepackage_relation_slide;Slide,
            --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.appearance,
             --palette--;;frames,
             --palette--;;appearanceLinks,
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:language,
             --palette--;;language,
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:access,
             --palette--;;hidden,
             --palette--;;access,
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:extended,
       ',
        'columnsOverrides' => array(
        )
    );

    // Adds the content element to the "Type" dropdown
    \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addPlugin(
        array(
            'Card-Slider',
            'sg_sitepackage_card_slider',
            'EXT:sg_sitepackage/Resources/Public/Icons/ContentElements/sg_sitepackage_card_slider.png'
        ),
        'CType',
        'sg_sitepackage'
    );
    // Configure the default backend fields for the content element
    $GLOBALS['TCA']['tt_content']['types']['sg_sitepackage_card_slider'] = array(
        'showitem' => '
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:general,
             --palette--;;general,
             tx_sg_sitepackage_relation_card;Card,
            --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.appearance,
             --palette--;;frames,
             --palette--;;appearanceLinks,
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:language,
             --palette--;;language,
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:access,
             --palette--;;hidden,
             --palette--;;access,
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:extended,
       ',
        'columnsOverrides' => array(
        )
    );


    /**
     * Content Element Card
     */
    \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addPlugin(
        array(
            'Card',
            'sg_sitepackage_card',
            'EXT:sg_sitepackage/Resources/Public/Icons/ContentElements/sg_sitepackage_card.png'
        ),
        'CType',
        'sg_sitepackage'
    );
    // Configure the default backend fields for the content element
    $GLOBALS['TCA']['tt_content']['types']['sg_sitepackage_card'] = array(
        'showitem' => '
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:general,
             --palette--;;general,
             tx_sg_sitepackage_type;Typ des Card-Elements,
             tx_sg_sitepackage_images;Header-Bild,
             tx_sg_sitepackage_headline;Überschrift,
             tx_sg_sitepackage_content;Teasertext,
             tx_sg_sitepackage_cta;Call-to-Action,
             tx_sg_sitepackage_cta_caption;Call-to-Action Beschriftung,
            --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.appearance,
             --palette--;;frames,
             --palette--;;appearanceLinks,
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:language,
             --palette--;;language,
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:access,
             --palette--;;hidden,
             --palette--;;access,
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:extended,
       ',
        'columnsOverrides' => array(
            'tx_sg_sitepackage_type' => array(
                'config' => array(
                    'items' => array (
                        array('Standard', ''),
                    ),
                )
            ),
            'tx_sg_sitepackage_images' => array(
                'config' => array(
                    'maxitems' => 1,
                )
            )
        )
    );

    /**
     * Content Element Card
     */
    \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addPlugin(
        array(
            'Teaser',
            'sg_sitepackage_teaser',
            'EXT:sg_sitepackage/Resources/Public/Icons/ContentElements/sg_sitepackage_teaser.png'
        ),
        'CType',
        'sg_sitepackage'
    );
    // Configure the default backend fields for the content element
    $GLOBALS['TCA']['tt_content']['types']['sg_sitepackage_teaser'] = array(
        'showitem' => '
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:general,
             --palette--;;general,
             tx_sg_sitepackage_images;Bild,
             tx_sg_sitepackage_content;Text,
            --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.appearance,
             --palette--;;frames,
             --palette--;;appearanceLinks,
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:language,
             --palette--;;language,
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:access,
             --palette--;;hidden,
             --palette--;;access,
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:extended,
       ',
        'columnsOverrides' => array(
            'tx_sg_sitepackage_images' => array(
                'config' => array(
                    'maxitems' => 1,
                )
            )
        )
    );


    /**
     * Content Element CTA
     */
    \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addPlugin(
        array(
            'Call To Action',
            'sg_sitepackage_cta',
            'EXT:sg_sitepackage/Resources/Public/Icons/ContentElements/sg_sitepackage_cta.png'
        ),
        'CType',
        'sg_sitepackage'
    );
    // Configure the default backend fields for the content element
    $GLOBALS['TCA']['tt_content']['types']['sg_sitepackage_cta'] = array(
        'showitem' => '
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:general,
             --palette--;;general,
             --palette--;;header,
             tx_sg_sitepackage_cta;Call-to-Action,
             tx_sg_sitepackage_cta_caption;Call-to-Action Beschriftung,
            --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.appearance,
             --palette--;;frames,
             --palette--;;appearanceLinks,
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:language,
             --palette--;;language,
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:access,
             --palette--;;hidden,
             --palette--;;access,
            --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:extended,
       ',
        'columnsOverrides' => array(
        )
    );

});