// require all neccessary gulp npm packages
var gulp = require('gulp');
var uglify = require('gulp-uglify');
var concat = require('gulp-concat');
var streamqueue = require('streamqueue');
var rename = require("gulp-rename");
var sass = require('gulp-sass');
var postcss = require( 'gulp-postcss' );
var sourcemaps = require('gulp-sourcemaps');
var plumber = require( 'gulp-plumber' );
var notify = require('gulp-notify');
var autoprefixer = require('autoprefixer');
var gutil = require('gulp-util');

// define all bower javascript dist files
var componentsFolder = "node_modules/";
var buildFolder = "Dist/";

/**
 * Define javascripts to combine and compress
 * @type {[*]}
 */
var javascript = [
  {
    scriptName: 'production',
    buildLocation: buildFolder + 'Js',
    distFiles: [
      componentsFolder+'popper.js/dist/umd/popper.js',
      componentsFolder+'bootstrap/dist/js/bootstrap.js',
      componentsFolder + 'slick-carousel/slick/slick.js',
      componentsFolder+'jquery-match-height/dist/jquery.matchHeight.js'
    ],
    additionalFiles: [
      'JavaScript/Libs/*.js',
      'JavaScript/main.js'
    ],
  },
];

/**
 * Files to copy from one to another location.
 * 0: destination folder relative to gulpfile
 * 1: destination filename
 * 2: path+file source file
 * 
 * @type {Array}
 */
var copyFilesArray = [
    ['Css/02-includes', '_jquery-slick.scss', componentsFolder + 'slick-carousel/slick/slick.scss'],
    ['Css/02-includes', '_jquery-slick-theme.scss', componentsFolder + 'slick-carousel/slick/slick-theme.scss'],
    ['Assets/build/images', 'ajax-loader.gif', componentsFolder + 'slick-carousel/slick/ajax-loader.gif'],
];

/**
 * Folders to copy to new destination
 * 0: destination folder
 * 1: source folder
 * 2: match pattern of files in folder that should be copied
 * 
 * @type {Array}
 */
var copyFoldersArray = [
    ['Assets/build/fonts', componentsFolder + 'slick-carousel/slick/fonts', '/*.*'],
];

/**
 * javascript files to watch for
 *
 * @type {Array}
 */
var javascriptWatch = [
  './JavaScript/Libs/*.js',
  './JavaScript/main.js',
];

/**
 * SCSS files to watch for
 *
 * @type {Array}
 */
var stylesWatch = [
  './Css/**/*.scss',
];

/**
 * Sass files to compile
 * 0: destination folder of .css and .css.map (same name)
 * 1: source files
 * 
 * @type {Array}
 */
var sassArray = [
	[buildFolder + 'Css', 'Css/global.scss'],
	[buildFolder + 'Css/Backend', 'Css/backend.scss'],
	[buildFolder + 'Css', 'Css/rte.scss']
];

/**
 * Copy files defined in copyFilesArray
 */
gulp.task('copy-files', function()
{
 	for( var i = 0; i < copyFilesArray.length; i++ )
 	{
 		gulp.src( copyFilesArray[i][2] )
 			.pipe( rename( copyFilesArray[i][1] ) )
 			.pipe( gulp.dest( copyFilesArray[i][0] ) );
 	}
});

/**
 * Copy folders defined in copyFoldersArray
 */
gulp.task('copy-folders', function()
{
 	for( var i = 0; i < copyFoldersArray.length; i++ )
 	{
 		gulp.src( copyFoldersArray[i][1]+copyFoldersArray[i][2] )
 			.pipe( gulp.dest( copyFoldersArray[i][0] ) );
 	}
});

/**
 * Concat javascript files in alphabetical order plus 1. npm defined distFiles 2. libs/rest,
 * produces concat version, then minifies concat version and outputs all to js/build
 */
gulp.task( 'scripts', function(){
    for( var i = 0; i < javascript.length; i++ )
    {
        var npmFiles = gulp.src( javascript[i].distFiles );
        var rest = gulp.src( javascript[i].additionalFiles );
        // saves both concat and concat + uglified version,
        // streamqueue takes npmFiles files in alphabetical order and
        // adds rest files in alphabetical order after npmFiles
        streamqueue( { objectMode: true }, npmFiles, rest )
            // catches errors so watch tasks wont break
            .pipe( plumber( {
                errorHandler: function( err ){
                    notify.onError( {
                        title: "Gulp error in " + err.plugin,
                        message: err.toString()
                    } )( err );

                    // play a sound once
                    // gutil.beep();
                }
            } ) )
            .pipe( concat( javascript[i].scriptName + '.js' ) )
            .pipe( gulp.dest( javascript[i].buildLocation ) )
            .pipe( rename( javascript[i].scriptName + '.min.js' ) )
            .pipe( uglify() )
            .pipe( gulp.dest( javascript[i].buildLocation ) );
    }
    return true;
} );

/**
 * compiles all sass files defined in sassFiles in compressed mode and writes sourcemap
 */
gulp.task('sass', function () {
  for( var i = 0; i < sassArray.length; i++ )
 	{
 		gulp.src( sassArray[i][1] )
 			// in order to write sourcefile we need to init sourcemaps first
 			.pipe( sourcemaps.init() )
 			// compile in compressed mode and log errors if an error occurs
 			.pipe( sass({outputStyle: 'compressed'}).on('error', sass.logError) )
            // autoprefix generated css
            .pipe( postcss([ autoprefixer() ]))
 			// write path is relative to gulp.dest. here: same folder
 			.pipe( sourcemaps.write('.') )
 			.pipe( gulp.dest( sassArray[i][0] ) );
 	}
});

/**
 * Watches for changes in sass files and then runs sass task
 */
gulp.task('sass:watch', function ()
{
  // triggers on all scss files in css folder
  gulp.watch( stylesWatch, ['sass'] );
});

/**
 * Watches for changes in script files and runs script task
 */
gulp.task('scripts:watch', function ()
{
  gulp.watch( javascriptWatch, ['scripts'] );
});

/**
 * Runs all watch tasks
 */
gulp.task('watch', ['sass:watch', 'scripts:watch'] );

/**
 * Runs all build and watch task.
 */
gulp.task('default', ['copy-folders', 'copy-files', 'scripts', 'sass', 'watch'] );

/**
 * Runs all build tasks.
 */
gulp.task('build', ['copy-folders', 'copy-files', 'scripts', 'sass'] );