// require all neccessary gulp npm packages
var gulp = require( 'gulp' );
var uglify = require( 'gulp-uglify' );
var concat = require( 'gulp-concat' );
var streamqueue = require( 'streamqueue' );
var rename = require( "gulp-rename" );
var sass = require( 'gulp-sass' );
var postcss = require( 'gulp-postcss' );
var sourcemaps = require( 'gulp-sourcemaps' );
var plumber = require( 'gulp-plumber' );
var notify = require( 'gulp-notify' );
var autoprefixer = require( 'autoprefixer' );

// define all bower javascript dist files
var componentsFolder = "node_modules/";
var buildFolder = "Dist/";

/**
 * Define javascripts to combine and compress
 * @type {[*]}
 */
var javascript = [
    {
        scriptName: 'production',
        buildLocation: buildFolder + 'Js',
        distFiles: [
            componentsFolder + 'popper.js/dist/umd/popper.js',
            componentsFolder + 'bootstrap/dist/js/bootstrap.js',
            componentsFolder + 'slick-carousel/slick/slick.js',
            componentsFolder + 'bxslider/dist/jquery.bxslider.js',
            componentsFolder + 'jquery-focuspoint/js/jquery.focuspoint.js',
            componentsFolder + 'jquery-match-height/dist/jquery.matchHeight.js'
        ],
        additionalFiles: [
            'JavaScript/Libs/*.js',
            'JavaScript/main.js'
        ],
    },
    {
        scriptName: 'jquery',
        buildLocation: buildFolder + 'Js',
        distFiles: [
            componentsFolder + 'jquery/dist/jquery.js'
        ],
        additionalFiles: []
    },
];

/**
 * Files to copy from one to another location.
 * 0: destination folder relative to gulpfile
 * 1: destination filename
 * 2: path+file source file
 *
 * @type {Array}
 */
var copyFilesArray = [
    ['Css/02-includes', '_jquery-slick.scss', componentsFolder + 'slick-carousel/slick/slick.scss'],
    ['Css/02-includes', '_jquery-slick-theme.scss', componentsFolder + 'slick-carousel/slick/slick-theme.scss'],
    ['Assets/build/images', 'ajax-loader.gif', componentsFolder + 'slick-carousel/slick/ajax-loader.gif'],
];

/**
 * Folders to copy to new destination
 * 0: destination folder
 * 1: source folder
 * 2: match pattern of files in folder that should be copied
 *
 * @type {Array}
 */
var copyFoldersArray = [
    ['Assets/build/fonts', componentsFolder + 'slick-carousel/slick/fonts', '/*.*'],
    ['Assets/build/fonts', componentsFolder + '@fortawesome/fontawesome-pro/webfonts/', '/fa-brands-*.*'],
    ['Assets/build/fonts', componentsFolder + '@fortawesome/fontawesome-pro/webfonts/', '/fa-light-*.*'],
    ['Assets/build/fonts', componentsFolder + '@fortawesome/fontawesome-pro/webfonts/', '/fa-regular-*.*'],
    ['Assets/build/fonts', componentsFolder + '@fortawesome/fontawesome-pro/webfonts/', '/fa-solid-*.*']
];

/**
 * javascript files to watch for
 *
 * @type {Array}
 */
var javascriptWatch = [
    './JavaScript/Libs/*.js',
    './JavaScript/main.js',
];

/**
 * SCSS files to watch for
 *
 * @type {Array}
 */
var stylesWatch = [
    './Css/**/*.scss',
];

/**
 * Sass files to compile
 * 0: destination folder of .css and .css.map (same name)
 * 1: source files
 *
 * @type {Array}
 */
var sassArray = [
    [buildFolder + 'Css', 'Css/global.scss'],
    [buildFolder + 'Css/Backend', 'Css/backend.scss'],
    [buildFolder + 'Css', 'Css/rte.scss']
];

/**
 * Copy files defined in copyFilesArray
 */
gulp.task( 'copy-files', done => {
    for( var i = 0; i < copyFilesArray.length; i++ )
    {
        gulp.src( copyFilesArray[i][2] )
            .pipe( rename( copyFilesArray[i][1] ) )
            .pipe( gulp.dest( copyFilesArray[i][0] ) );
    }
    done();
} );

/**
 * Copy folders defined in copyFoldersArray
 */
gulp.task( 'copy-folders', done => {
    for( var i = 0; i < copyFoldersArray.length; i++ )
    {
        gulp.src( copyFoldersArray[i][1] + copyFoldersArray[i][2] )
            .pipe( gulp.dest( copyFoldersArray[i][0] ) );
    }
    done();
} );

/**
 * Concat javascript files in alphabetical order plus 1. npm defined distFiles 2. libs/rest,
 * produces concat version, then minifies concat version and outputs all to js/build
 */
gulp.task( 'scripts', done => {
    for( var i = 0; i < javascript.length; i++ )
    {
        var streamVar;
        var npmFiles = gulp.src( javascript[i].distFiles );
        if (javascript[i].additionalFiles.length > 0){
            var rest = gulp.src( javascript[i].additionalFiles );
            // saves both concat and concat + uglified version,
            // streamqueue takes npmFiles files in alphabetical order and
            // adds rest files in alphabetical order after npmFiles
            streamVar = streamqueue( { objectMode: true }, npmFiles, rest );
        }else{
            streamVar = streamqueue( { objectMode: true }, npmFiles);
        }

        // catches errors so watch tasks wont break
        streamVar.pipe( plumber( {
                errorHandler: function( err ){
                    notify.onError( {
                        title: "Gulp error in " + err.plugin,
                        message: err.toString()
                    } )( err );
                }
            } ) )
            .pipe( concat( javascript[i].scriptName + '.js' ) )
            .pipe( gulp.dest( javascript[i].buildLocation ) )
            .pipe( rename( javascript[i].scriptName + '.min.js' ) )
            .pipe( uglify() )
            .pipe( gulp.dest( javascript[i].buildLocation ) );
    }
    done();
} );

/**
 * compiles all sass files defined in sassFiles in compressed mode and writes sourcemap
 */
gulp.task( 'sass', done => {
    for( var i = 0; i < sassArray.length; i++ )
    {
        gulp.src( sassArray[i][1] )
            // in order to write sourcefile we need to init sourcemaps first
            .pipe( sourcemaps.init() )
            // compile in compressed mode and log errors if an error occurs
            .pipe( sass( { outputStyle: 'compressed' } ).on( 'error', sass.logError ) )
            // autoprefix generated css
            .pipe( postcss( [autoprefixer()] ) )
            // write path is relative to gulp.dest. here: same folder
            .pipe( sourcemaps.write( '.' ) )
            .pipe( gulp.dest( sassArray[i][0] ) );
    }
    done();
} );

/**
 * Watches for changes in sass files and then runs sass task
 */
gulp.task( 'sass:watch', function(){
    // triggers on all scss files in css folder
    gulp.watch( stylesWatch, gulp.series( 'sass' ) );
} );

/**
 * Watches for changes in script files and runs script task
 */
gulp.task( 'scripts:watch', function(){
    gulp.watch( javascriptWatch, gulp.series( 'scripts' ) );
} );

/**
 * Runs all watch tasks
 */
gulp.task( 'watch', gulp.parallel( 'sass:watch', 'scripts:watch' ) );

/**
 * Runs all build and watch task.
 */
gulp.task( 'default', gulp.series( 'copy-folders', 'copy-files', 'scripts', 'sass', 'watch' ) );

/**
 * Runs all build tasks.
 */
gulp.task( 'build', gulp.series( 'copy-folders', 'copy-files', 'scripts', 'sass' ) );