<?php

use \TYPO3\CMS\Core\Utility\GeneralUtility;
use \Helhum\ConfigLoader\ConfigurationLoader;
use \Helhum\ConfigLoader\Reader\PhpFileReader;
use \Helhum\ConfigLoader\Reader\EnvironmentReader;

/**
 * TYPO3 Conf Vars Environment Configuration Stack
 * We let the loader load context and environment specific configuration
 * No other code must go in here!
 *
 * Only possible values are Development, Testing and Production. All other will
 * produce a TYPO3 exception
 */
$context = strtolower(GeneralUtility::getApplicationContext());

// __DIR__ returns the abs. path of the current script (AdditionalConfiguration.php)
$confDir = dirname(dirname(__DIR__)) . '/conf';

// Build the configuration stack
$configLoader = new ConfigurationLoader(
    array(
        new PhpFileReader($confDir . '/default.php'),
        new PhpFileReader($confDir . '/' . $context . '.php'),
        new EnvironmentReader('TYPO3'),
        new PhpFileReader($confDir . '/override.php'),
    )
);

// Now do the actual configuration merge
try {
    $GLOBALS[ 'TYPO3_CONF_VARS' ] = array_replace_recursive(
        $GLOBALS[ 'TYPO3_CONF_VARS' ],
        $configLoader->load()
    );
} catch (\Exception $e) {
    echo $e->getMessage();
}
