<?php
namespace SG\Sitepackage\Hooks\PageLayoutView;

use \TYPO3\CMS\Backend\View\PageLayoutViewDrawItemHookInterface;
use \TYPO3\CMS\Backend\View\PageLayoutView;
use \TYPO3\CMS\Core\Utility\GeneralUtility;
use \TYPO3\CMS\Core\Database\ConnectionPool;
use \TYPO3\CMS\Fluid\View\StandaloneView;
use \TYPO3\CMS\Backend\Utility\BackendUtility;
use \TYPO3\CMS\Core\Database\Query\QueryBuilder;

/**
 * Contains preview rendering for the page module
 */
class ContentElementPreviewRenderer implements PageLayoutViewDrawItemHookInterface
{

    /**
     * Preprocesses the preview rendering of content elements of this extension
     *
     * @param \TYPO3\CMS\Backend\View\PageLayoutView $parentObject Calling parent object
     * @param bool $drawItem Whether to draw the item using the default functionality
     * @param string $headerContent Header content
     * @param string $itemContent Item content
     * @param array $row Record row of tt_content
     *
     * @return void
     */
    public function preProcess(
        PageLayoutView &$parentObject,
        &$drawItem,
        &$headerContent,
        &$itemContent,
        array &$row
    ) {
        // only go deeper if this CType belongs to our package
        $isPackageContentElement = strpos($row[ 'CType' ], 'sg_sitepackage_') !== false;
        if ($isPackageContentElement) {
            $getTemplatePart = $this->snakeToCamelCase(str_replace('sg_sitepackage_', '', $row[ 'CType' ]), true);
            /**
             * @var StandaloneView $fluidTemplate
             */
            $templateFilePath = GeneralUtility::getFileAbsFileName(
                'EXT:sg_sitepackage/Resources/Private/Templates/ContentPreview/'.$getTemplatePart.'.html');
            // Only proceed if template was found
            if ($templateFilePath !== '' && file_exists($templateFilePath)) {
                // process images if set
                $imagesPreview = false;
                if ($row['tx_sg_sitepackage_images'] != '0') {
                    $imagesPreview = BackendUtility::thumbCode(
                        $row,
                        'tt_content', 'tx_sg_sitepackage_images');
                }
                $row['imagesPreview'] = $imagesPreview;

                // process relations for inline child elements
                // we use a relations configuration array
                // to determine how to retrieve and transfer the gathered data and items
                $relations = [
                    'tx_sg_sitepackage_relation_slide' => [
                        'table' => 'tx_sg_sitepackage_slide',
                        'as'    => 'slides'
                    ],
                    'tx_sg_sitepackage_relation_card'  => [
                        'table' => 'tx_sg_sitepackage_card',
                        'as'    => 'cards'
                    ],
                    'tx_sg_sitepackage_relation_contentpane'  => [
                        'table' => 'tx_sg_sitepackage_contentpane',
                        'as'    => 'contentpanes'
                    ],
                ];
                $resolvedRelations = [];

                foreach ($relations as $relation => $configuration) {
                    $items = [];
                    if ($row[ $relation ] > 0) {
                        $items = $this->getInlineChildElements($configuration['table'], $row['uid']);
                        // resolve images in inline elements
                        foreach ($items as $key => $item) {
                            if (isset($item['images'])) {
                                $inlineItemsImages = false;
                                if ($item['images'] != '0') {
                                    $inlineItemsImages = \TYPO3\CMS\Backend\Utility\BackendUtility::thumbCode(
                                        $item,
                                        $configuration['table'],
                                        'images'
                                    );
                                }
                                $items[ $key ]['imagesPreview'] = $inlineItemsImages;
                            }
                        }
                    }
                    $resolvedRelations[ $configuration['as'] ] = $items;
                }

                $template = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Fluid\View\StandaloneView');
                $template->setTemplatePathAndFilename($templateFilePath);

                $template->assign('data', $row);
                // assign data from relations
                foreach ($resolvedRelations as $resolvedRelationName => $resolvedRelationItems) {
                    $template->assign($resolvedRelationName, $resolvedRelationItems);
                }

                // render the actual view
                $itemContent = $parentObject->linkEditContent($template->render(), $row);
                // prevent default rendering
                $drawItem = false;
                // we do not need normal header. We use own instead
                $headerContent = '';
            }
        }
    }

    /**
     * Convert a given string in snake case to camel case
     *
     * @param      $string
     * @param bool $capitalizeFirstCharacter
     *
     * @return mixed
     */
    public function snakeToCamelCase($string, $capitalizeFirstCharacter = false)
    {
        $str = str_replace(' ', '', ucwords(str_replace('_', ' ', $string)));

        if (!$capitalizeFirstCharacter) {
            $str[0] = strtolower($str[0]);
        }

        return $str;
    }

    /**
     * Retrieve all inline child elements of a given content elements
     * from the database and return the rows as an array
     *
     * @param string $table
     * @param int    $uid
     *
     * @return array
     */
    public function getInlineChildElements($table = '', $uid = 0)
    {
        /**
         * @var $queryBuilder QueryBuilder
         */
        $r = [];
        if ($table !== '' && $uid > 0) {
            $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable($table);
            $statement = $queryBuilder
                ->select('*')
                ->from($table)
                ->where(
                    $queryBuilder->expr()->eq('tt_content', $queryBuilder->createNamedParameter((int) $uid))
                )
                ->execute();

            while ($item = $statement->fetch()) {
                $r[] = $item;
            }
        }
        return $r;
    }
}
