#!/bin/bash

## Description: get content from external system
## Usage: getcontent [flags] [args]
## Example: "ddev getcontent --skipfiles --sshUser=aaa --host=bbb --typo3root=/zz/zz/"

sshUser=$GETCONTENT_SSHUSER
host=$GETCONTENT_HOST
typo3root=$GETCONTENT_TYPO3ROOT
skipfiles=false

while [ $# -gt 0 ]; do
  case "$1" in
    --sshUser=*)
      sshUser="${1#*=}"
      ;;
    --host=*)
      host="${1#*=}"
      ;;
    --typo3root=*)
      typo3root="${1#*=}"
      ;;
    --skipfiles*)
      skipfiles=true
      ;;
    *)
      printf "***************************\n"
      printf "* Error: Invalid argument.*\n"
      printf "***************************\n"
      exit 1
  esac
  shift
done

# Sync Database to ddev Environment
ssh "$sshUser"@"$host" "$typo3root/current/vendor/bin/typo3cms database:export" | /var/www/html/vendor/bin/typo3cms database:import

# Sync Fileadmin to ddev Environment
if [ $skipfiles = "false" ]
then
  rsync -avz --delete --exclude="_processed_" --exclude="_temp_" -e ssh "$sshUser"@"$host":"$typo3root/shared/public/fileadmin/" "/var/www/html/public/fileadmin/"
fi

/var/www/html/vendor/bin/typo3cms cache:flush