<?php

use \TYPO3\CMS\Core\Utility\GeneralUtility;
use \Helhum\ConfigLoader\ConfigurationLoader;
use \Helhum\ConfigLoader\Reader\PhpFileReader;
use \Helhum\ConfigLoader\Reader\EnvironmentReader;

// We let the loader load context and environment specific configuration
// No other code must go in here!
$context = GeneralUtility::getApplicationContext()->isProduction() ? 'production' : 'development';

// __DIR__ returns the abs. path of the current script (AdditionalConfiguration.php)
$confDir = dirname(dirname(__DIR__)).'/conf';

$configLoader = new ConfigurationLoader(
    array(
        new PhpFileReader($confDir . '/default.php'),
        new PhpFileReader($confDir . '/' . $context . '.php'),
        new EnvironmentReader('TYPO3'),
        new PhpFileReader($confDir . '/override.php'),
    )
);

try{
    $GLOBALS['TYPO3_CONF_VARS'] = array_replace_recursive(
        $GLOBALS['TYPO3_CONF_VARS'],
        $configLoader->load()
    );
} catch (\Exception $e){
    echo $e->getMessage();
}
