<?php

namespace SG\Sitepackage\Service;

use SG\Sitepackage\Frontend\DataProcessing\FilesProcessor;

/**
 * Class BacktraceService
 * Offers a static function to build a backtrace tree list to use in slideUp processors
 * @see FilesProcessor for usage
 * @package SG\Sitepackage\Service
 */
class BacktraceService
{
    public static $PageBacktraceTreeList = array();

    public static function getPageBacktraceTreeList(
        $iPid,
        \TYPO3\CMS\Frontend\Page\PageRepository $pageRepository = null
    ) {
        if ( ! array_key_exists($iPid, self::$PageBacktraceTreeList) || ! self::$PageBacktraceTreeList[ $iPid ]) {
            if (is_null($pageRepository)) {
                $objectManager = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Object\ObjectManager');
                $pageRepository = $objectManager->get('TYPO3\CMS\Frontend\Page\PageRepository');
            }

            $page = $pageRepository->getPage($iPid);

            if ($page[ 'pid' ]) {
                self::$PageBacktraceTreeList[ $iPid ] = self::getPageBacktraceTreeList($page[ 'pid' ],
                        $pageRepository) . ',' . $iPid;
            } else {
                self::$PageBacktraceTreeList[ $iPid ] = '' . $iPid;
            }
        }

        return self::$PageBacktraceTreeList[ $iPid ];
    }
}