;(function($, window, document, undefined) {
  'use strict';
  var cssTransitionSupport = function() {
    var s = document.body || document.documentElement;
    s = s.style;
    if (s.WebkitTransition === '') {
      return '-webkit-';
    };
    if (s.MozTransition === '') {
      return '-moz-';
    };
    if (s.OTransition === '') {
      return '-o-';
    };
    if (s.transition === '') {
      return '';
    };
    return false;
  };
  var isCssTransitionSupport = cssTransitionSupport() !== false;
  var cssTransitionTranslateX = function(element, positionX, speed) {
    var options = {}, prefix = cssTransitionSupport();
    options[prefix + 'transform'] = 'translateX(' + positionX + ')';
    options[prefix + 'transition'] = prefix + 'transform ' + speed + 's linear';
    element.css(options);
  };
  var hasTouch = ('ontouchstart' in window);
  var hasPointers = window.navigator.pointerEnabled || window.navigator.msPointerEnabled;
  var wasTouched = function(event) {
    if (hasTouch) {
      return true;
    };
    if (!hasPointers || typeof event === 'undefined' || typeof event.pointerType === 'undefined') {
      return false;
    };
    if (typeof event.MSPOINTER_TYPE_MOUSE !== 'undefined') {
      if (event.MSPOINTER_TYPE_MOUSE !== event.pointerType) {
        return true;
      };
    } else if (event.pointerType !== 'mouse') {
      return true;
    };
    return false;
  };

  $.fn.timtilch_lightbox = function(opts) {
    var options = $.extend({
      selector: 'a.timtilch_lightbox',
      id: 'timtilch_lightbox',
      allowedTypes: 'png|jpg|jpeg||gif',
      animationSpeed: 300,
      preloadNext: true,
      enableKeyboard: true,
      activity: true,
      arrows: true,
      button: true,
      navigation: true,
      overlay: true,
      caption: true,
      quitOnEnd: true,
      quitOnImgClick: true,
      quitOnDocClick: true,
      quitOnEscKey: true,
      onStart: function() {
        arrowsOn(this);
        navigationOn(this, options.selector);
        overlayOn();
        closeButtonOn();
        downloadOn();
      },
      onEnd: function() {
        activityIndicatorOff();
        arrowsOff();
        navigationOff();
        overlayOff();
        captionOff();
        closeButtonOff();
        downloadOff();
      },
      onLoadStart: function() {
        activityIndicatorOn();
        captionOff();
      },
      onLoadEnd: function() {
        activityIndicatorOff();
        arrowsOn();
        navigationUpdate(options.selector);
        captionOn();
        setDownload();
      },
      previousTarget: function() {
        return this.previousTargetDefault();
      },
      previousTargetDefault: function() {
        var targetIndex = targets.index(target) - 1;
        if (targetIndex < 0) {
          if (options.quitOnEnd === true) {
            quitLightbox();
            return false;
          } else {
            targetIndex = targets.length - 1;
          };
        };
        target = targets.eq(targetIndex);
      },
      nextTarget: function() {
        return this.nextTargetDefault();
      },
      nextTargetDefault: function() {
        var targetIndex = targets.index(target) + 1;
        if (targetIndex >= targets.length) {
          if (options.quitOnEnd === true) {
            quitLightbox();
            return false;
          } else {
            targetIndex = 0;
          };
        };
        target = targets.eq(targetIndex);
      }
    }, opts),
    activityIndicatorOn = function() {
      $('.timtilch_lightbox_loading').addClass('active');
    },
    activityIndicatorOff = function() {
      $('.timtilch_lightbox_loading').removeClass('active');
    },
    overlayOn = function() {
      $('.timtilch_lightbox_overlay').addClass('active');
    },
    overlayOff = function() {
      $('.timtilch_lightbox_overlay').removeClass('active');
    },
    closeButtonOn = function() {
      $('.timtilch_lightbox_close').on('click', function() {
        $('.timtilch_lightbox_close').removeClass('active');
        quitLightbox();
        return false;
      });
      $('.timtilch_lightbox_close').addClass('active');
    },
    closeButtonOff = function() {
      $('.timtilch_lightbox_close').removeClass('active');
      $('.timtilch_lightbox_download').removeClass('active');
    },
    captionOn = function() {
      var description = $(target).find('img').attr('title');
      if (description && description.length > 0) {
        $('.timtilch_lightbox_caption').html(description).addClass('active');
      };
    },
    captionOff = function() {
      $('.timtilch_lightbox_caption').removeClass('active');
    },
    navigationOn = function(instance, selector) {
      var images = $(selector);
      if (images.length) {
        var nav = $('.timtilch_lightbox_navigation');
        for (var i = 0; i < images.length; i++) {
          nav.append('<a href="#"></a>');
        }
        $('.timtilch_lightbox_navigation').addClass('active')
        nav.on('click touchend', function () {
          return false;
        });
        var navItems = nav.find('a');
        navItems.on('click touchend', function () {
          var $this = $(this);
          if (images.eq($this.index()).attr('href') !== $('#timtilch_lightbox').attr('src')) {
            var tmpTarget = targets.eq($this.index());
            if (tmpTarget.length) {
              var currentIndex = targets.index(target);
              target = tmpTarget;
              loadImage($this.index() < currentIndex ? 'left' : 'right');
            };
          };
          navItems.removeClass('active');
          navItems.eq($this.index()).addClass('active');
          return false;
        }).on('touchend', function () {
          return false;
        });
      };
    },
    navigationUpdate = function (selector) {
      var items = $('.timtilch_lightbox_navigation').find('a');
      items.removeClass('active');
      items.eq($(selector).filter('[href="' + $('#timtilch_lightbox').attr('src') + '"]').index(selector)).addClass('active');
    },
    navigationOff = function () {
      $('.timtilch_lightbox_navigation').removeClass('active');
      setTimeout(function() {
        $('.timtilch_lightbox_navigation a').remove();
      }, options.animationSpeed);
    },
    downloadOn = function() {
      $('.timtilch_lightbox_download').addClass('active');
      $('.timtilch_lightbox_download').on('click touchend', function(event) {
        event.stopPropagation();
      });
    },
    downloadOff = function() {
      $('.timtilch_lightbox_download').removeClass('active');
    },
    setDownload = function() {
      var source = $('#timtilch_lightbox').attr('src');
      $('.timtilch_lightbox_download').attr('href',source)
    },
    arrowsOn = function(instance) {
      var $arrows = $('.timtilch_lightbox_arrow');
      $arrows.off('click touchend');
      $('.timtilch_lightbox_arrow').addClass('active');
      $arrows.on('click touchend', function(e) {
        e.preventDefault();
        if ($(this).hasClass('timtilch_lightbox_arrow_left')) {
          loadPreviousImage(instance);
        } else {
          loadNextImage(instance);
        };
        return false;
      });
    },
    arrowsOff = function() {
      $('.timtilch_lightbox_arrow').removeClass('active');
    },
    targets = $([]),
    target = $(),
    image = $(),
    imageWidth = 0,
    imageHeight = 0,
    swipeDiff = 0,
    inProgress = false,
    isTargetValid = function(element) {
      var classic = $(element).prop('tagName').toLowerCase() === 'a' && ( new RegExp('.(' + options.allowedTypes + ')$', 'i') ).test($(element).attr('href'));
      var html5 = $(element).attr('data-lightbox') !== undefined;
      return classic || html5;
    },
    setImage = function() {
      if (!image.length) {
        return true;
      };
      var screenWidth = $(window).width() * 0.8;
      var screenHeight = $(window).height() * 0.9;
      var tmpImage = new Image();
      tmpImage.src = image.attr('src');
      tmpImage.onload = function() {
        imageWidth = tmpImage.width;
        imageHeight = tmpImage.height;
        if (imageWidth > screenWidth || imageHeight > screenHeight) {
          var ratio = imageWidth / imageHeight > screenWidth / screenHeight ? imageWidth / screenWidth : imageHeight / screenHeight;
          imageWidth /= ratio;
          imageHeight /= ratio;
        };
        image.css({
          'width': imageWidth + 'px',
          'height': imageHeight + 'px',
          'top': ( $(window).height() - imageHeight ) / 2 + 'px',
          'left': ( $(window).width() - imageWidth ) / 2 + 'px'
        });
      };
    },
    loadImage = function(direction) {
      if (inProgress) {
        return false;
      };
      direction = typeof direction === 'undefined' ? false : direction === 'left' ? 1 : -1;
      if (image.length) {
        var params = {'opacity': 0};
        if (isCssTransitionSupport) {
          cssTransitionTranslateX(image, ( 100 * direction ) - swipeDiff + 'px', options.animationSpeed / 1000);
        } else {
          params.left = parseInt(image.css('left')) + 100 * direction + 'px';
        };
        image.animate(params, options.animationSpeed, function() {
          removeImage();
        });
        swipeDiff = 0;
      };
      inProgress = true;
      if (options.onLoadStart !== false) {
        options.onLoadStart();
      };
      setTimeout(function() {
        var imgPath = target.attr('href');
        // if ( imgPath === undefined ) {
        //     imgPath = target.attr( 'data-lightbox' );
        // }
        image = $('<img id="' + options.id + '" />').attr('src', imgPath).load(function() {
          var params = {'opacity': 1};
          image.appendTo('.timtilch_lightbox_wrapper');
          setImage();
          image.css('opacity', 0);
          if (isCssTransitionSupport) {
            cssTransitionTranslateX(image, -100 * direction + 'px', 0);
            setTimeout(function() {
              cssTransitionTranslateX(image, 0 + 'px', options.animationSpeed / 1000);
            }, 50);
          } else {
            var imagePosLeft = parseInt(image.css('left'));
            params.left = imagePosLeft + 'px';
            image.css('left', imagePosLeft - 100 * direction + 'px');
          };
          image.animate(params, options.animationSpeed, function() {
            inProgress = false;
            if (options.onLoadEnd !== false) {
              options.onLoadEnd();
            };
          });
          if (options.preloadNext) {
            var nextTarget = targets.eq(targets.index(target) + 1);
            if (!nextTarget.length) {
              nextTarget = targets.eq(0);
            };
            $('<img />').attr('src', nextTarget.attr('href')).load();
          };
        }).error(function() {
          if (options.onLoadEnd !== false) {
            options.onLoadEnd();
          };
        });
        var swipeStart = 0;
        var swipeEnd = 0;
        var imagePosLeft = 0;
        image.on(hasPointers ? 'pointerup MSPointerUp' : 'click', function(e) {
          e.preventDefault();
          if (options.quitOnImgClick) {
            quitLightbox();
            return false;
          };
          if (wasTouched(e.originalEvent)) {
            return true;
          };
          var posX = ( e.pageX || e.originalEvent.pageX ) - e.target.offsetLeft;
          if (imageWidth / 2 > posX) {
            loadPreviousImage();
          } else {
            loadNextImage();
          };
        }).on('touchstart pointerdown MSPointerDown', function(e) {
          if (!wasTouched(e.originalEvent) || options.quitOnImgClick) {
            return true;
          };
          if (isCssTransitionSupport) {
            imagePosLeft = parseInt(image.css('left'));
          };
          swipeStart = e.originalEvent.pageX || e.originalEvent.touches[0].pageX;
        }).on('touchmove pointermove MSPointerMove', function(e) {
          if (!wasTouched(e.originalEvent) || options.quitOnImgClick) {
            return true;
          };
          e.preventDefault();
          swipeEnd = e.originalEvent.pageX || e.originalEvent.touches[0].pageX;
          swipeDiff = swipeStart - swipeEnd;
          if (isCssTransitionSupport) {
            cssTransitionTranslateX(image, -swipeDiff + 'px', 0);
          } else {
            image.css('left', imagePosLeft - swipeDiff + 'px');
          };
        }).on('touchend touchcancel pointerup pointercancel MSPointerUp MSPointerCancel', function(e) {
          if (!wasTouched(e.originalEvent) || options.quitOnImgClick) {
            return true;
          };
          if (Math.abs(swipeDiff) > 50) {
            if (swipeDiff < 0) {
              loadPreviousImage();
            } else {
              loadNextImage();
            };
          } else {
            if (isCssTransitionSupport) {
              cssTransitionTranslateX(image, 0 + 'px', options.animationSpeed / 1000);
            } else {
              image.animate({'left': imagePosLeft + 'px'}, options.animationSpeed / 2);
            };
          };
        });
      }, options.animationSpeed + 100);
    },
    loadPreviousImage = function() {
      if (options.previousTarget() !== false) {
        loadImage('left');
      };
    },
    loadNextImage = function() {
      if (options.nextTarget() !== false) {
        loadImage('right');
      };
    },
    removeImage = function() {
      if (!image.length) {
        return false;
      };
      image.remove();
      image = $();
    },
    quitLightbox = function() {
      if (!image.length) {
        return false;
      };
      image.animate({'opacity': 0}, options.animationSpeed, function() {
        removeImage();
        inProgress = false;
        if (options.onEnd !== false) {
          options.onEnd();
        };
      });
    };
    $(window).on('resize', setImage);
    if (options.quitOnDocClick) {
      $(document).on(hasTouch ? 'touchend' : 'click', function(e) {
        if (image.length && !$(e.target).is(image)) {
          e.preventDefault();
          quitLightbox();
        };
      });
    };
    if (options.enableKeyboard) {
      $(document).on('keyup', function(e) {
        if (!image.length) {
          return true;
        };
        e.preventDefault();
        if (e.keyCode === 27 && options.quitOnEscKey === true) {
          quitLightbox();
        };
        if (e.keyCode === 37) {
          loadPreviousImage();
        } else if (e.keyCode === 39) {
          loadNextImage();
        };
      });
    };
    this.startImageLightbox = function(e) {
      if (!isTargetValid(this)) {
        return true;
      };
      if (e !== undefined) {
        e.preventDefault();
      };
      if (inProgress) {
        return false;
      };
      inProgress = false;
      if (options.onStart !== false) {
        options.onStart();
      };
      target = $(this);
      loadImage();
    };
    $(document).off('click', this.selector);
    $(document).on('click', this.selector, this.startImageLightbox);
    this.each(function() {
      if (!isTargetValid(this)) {
        return true;
      };
      targets = targets.add($(this));
    });
    this.loadPreviousImage = function() {
      loadPreviousImage();
    };
    this.loadNextImage = function() {
      loadNextImage();
    };
    this.quitImageLightbox = function() {
      quitLightbox();
      return this;
    };
    // You can add the other targets to the image queue.
    this.addImageLightbox = function(elements) {
      elements.each(function() {
        if (!isTargetValid(this)) {
          return true;
        };
        targets = targets.add($(this));
      });
      elements.click(this.startImageLightbox);
      return this;
    };
    return this;
  };
})(jQuery, window, document);
