<?php

namespace SG\Sitepackage\Backend\ToolbarItem;

use TYPO3\CMS\Backend\Backend\ToolbarItems\SystemInformationToolbarItem;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use TYPO3\CMS\Core\Package\Exception;

/**
 * VersionToolbarItem
 */
class VersionToolbarItem
{
    /**
     * Called by the system information toolbar signal/slot dispatch.
     *
     * @param SystemInformationToolbarItem $systemInformation
     * @throws Exception
     */
    public function addVersionInformation(SystemInformationToolbarItem $systemInformation)
    {
        $value = ExtensionManagementUtility::getExtensionVersion('sg_sitepackage');
        // Set system information entry
        $systemInformation->addSystemInformation(
            'Sitepackage',
            htmlspecialchars($value, ENT_QUOTES | ENT_HTML5),
            'sg_sitepackage_systeminformation'
        );
    }
}
