window.addEventListener("load", function () {
    function CookieConsent() {
        this.cookie_name = 'sg_cookieconsent_status';
        this.cookie = {
            // This is the url path that the cookie 'name' belongs to. The cookie can only be read at this location
            path: '/',
            // This is the domain that the cookie 'name' belongs to. The cookie can only be read on this domain.
            //  - Guide to cookie domains - https://www.mxsasha.eu/blog/2014/03/04/definitive-guide-to-cookie-domains/
            domain: '',
            // The cookies expire date, specified in days (specify -1 for no expiry)
            expiryDays: 365,
            // If true the cookie will be created with the secure flag. Secure cookies will only be transmitted via HTTPS.
            secure: false
        };
    }

    /** Async Load Ressources **/
    CookieConsent.prototype.asyncLoad = function (u, t, c) {
        var d = document,
            o = d.createElement(t),
            s = d.getElementsByTagName(t)[0];

        switch (t) {
            case 'script':
                o.src = u;
                o.setAttribute('defer', '');
                break;
            case 'link':
                o.rel = 'stylesheet';
                o.type = 'text/css';
                o.setAttribute('defer', '');
                o.href = u;
                break;
        }
        if (c) {
            o.addEventListener('load', function (e) {
                c(null, e);
            }, false);
        }
        s.parentNode.insertBefore(o, s);
    };
    /** Async Load Helper for JS **/
    CookieConsent.prototype.asyncJS = function (u, c) {
        this.asyncLoad(u, 'script', c);
    };
    /** Async Load Helper for CSS **/
    CookieConsent.prototype.asyncCSS = function (u) {
        this.asyncLoad(u, 'link');
    };
    /** Callback after cookies are allowed **/
    CookieConsent.prototype.loadCookies = function () {
        /** Get all Scripts to load **/
        var elements = [];
        if (typeof document.querySelectorAll == 'undefined') {
            elements = document.querySelectorAll('script[data-cookieconsent]');
        } else {
            var temp = document.getElementsByTagName('script');
            for (var key in temp) {
                var element = temp[key];
                if (typeof element.getAttribute != 'undefined' && element.getAttribute('data-cookieconsent')) {
                    elements.push(element);
                }
            }
            temp = null;
        }
        if (elements.length > 0) {
            /** Loop through elements and run Code **/
            for (var key in elements) {
                /** get HTML of Elements **/
                var code = elements[key].innerHTML;
                /** trim Elements **/
                if (code && code.length) code = code.trim();
                /** Chekbox Access check **/
                var group = elements[key].dataset.cookieconsent;
                if(group != 'rquired') {
                    // load cookies
                    this.loadCookiesPreset();
                    // check if value exist
                    if( !this.sgCookies.hasOwnProperty('sg--cookie-'+group) || this.sgCookies['sg--cookie-'+group] !== true) {
                        // abort script
                        continue;
                    }
                }
                /** run Code it something in in it **/
                if (code && code.length) {
                    /** if Is Code Eval Code **/
                    eval.call(this, code);
                } else {
                    /** If is SRC load that **/
                    var element = elements[key];
                    /**
                     * Load SRC
                     * Dont use this src="", becouse some Browser will ignore the type=text/plain
                     * prefer use data-src=""
                     */
                    if (element.getAttribute('data-src')) {
                        this.asyncJS(element.getAttribute('data-src'));
                    } else if (element.src) {
                        this.asyncJS(element.src);
                    }
                }
            }
        }

    };
    /** load Scripts **/
    CookieConsent.prototype.load = function () {
        /** Load Javascript **/
        this.asyncJS(window.cookieconsent_options.js, this.init);
    };
    /** Toogle Body Class **/
    CookieConsent.prototype.setClass = function (remove) {
        if (remove === true) {
            document.querySelector('body').classList.remove('sg--cookie-consent');
        } else {
            document.querySelector('body').classList.add('sg--cookie-consent');
        }
    };
    /** Checkbox Handling **/
    CookieConsent.prototype.setCheckboxes = function () {
        // load checkboxes
        var statistik = this.loadCheckbox('sg--cookie-statistics'),
            marketing = this.loadCheckbox('sg--cookie-marketing');
        // save Cookie Values
        this.saveCookie([statistik, marketing]);
    };
    CookieConsent.prototype.loadCheckboxes = function () {
        // load cookies
        this.loadCookiesPreset();
        // load Checkboxes and set default values
        var statistik = this.loadCheckbox('sg--cookie-statistics', true),
            marketing = this.loadCheckbox('sg--cookie-marketing', true);

    };
    /** Save checkbox values to Cookie**/
    CookieConsent.prototype.saveCookie = function (values) {
        var object = {};
        // build Store object
        values.map(function (e) {
            object[e.id] = e.checked;
        });
        // save script selection
        window.cookieconsent.utils.setCookie(
            this.cookie_name,
            JSON.stringify(object),
            this.cookie.expiryDays,
            this.cookie.domain,
            this.cookie.path,
            this.cookie.secure
        );

    };
    /** Load Cookies **/
    CookieConsent.prototype.loadCookiesPreset = function(){
        if( this.sgCookies != false) this.sgCookies = window.cookieconsent.utils.getCookie(this.cookie_name);
        if (typeof this.sgCookies != 'undefined') {
            try {
                this.sgCookies = JSON.parse(this.sgCookies);
            } catch(error) {
                this.sgCookies = false;
            }
        } else {
            this.sgCookies = false;
        }
    };
    /** Load Checkboxes by name and fill Cookie value**/
    CookieConsent.prototype.loadCheckbox = function (id, cookieLoad) {
        var checkbox = document.getElementById(id);
        // load Cookie Value
        if (cookieLoad === true) {
            // get checkbox Value
            if(this.sgCookies && this.sgCookies.hasOwnProperty(id)) {
                checkbox.checked = this.sgCookies[id];
            }
        }
        // return element
        return checkbox;
    };
    /** Init Cookie Plugin **/
    CookieConsent.prototype.init = function () {
        /** Bind Self to Handler Class Funktions **/
        window.cookieconsent.initialise({
            enabled: !window.cookieconsent_options.hide,
            content: window.cookieconsent_options.content,
            theme: window.cookieconsent_options.theme,
            position: window.cookieconsent_options.position,
            palette: window.cookieconsent_options.palette,
            dismissOnScroll: window.cookieconsent_options.dismissOnScroll,
            type: window.cookieconsent_options.type,
            revokable: window.cookieconsent_options.revokable,
            cookie: (new CookieConsent()).cookie,
            compliance: {
                "opt-in": '<div class="cc-compliance cc-highlight">{{allow}}</div>'
            },
            layouts: {
                basic: "{{sgmessagelink}}{{compliance}}",
            },
            elements: {
                header: '{{header}}',
                allow: '<div class="row mx-1 mx-md-0"><div class="col-12 col-md-6"><a aria-label="allow cookies" role="button" tabindex="0" class="cc-btn cc-allow btn btn-block btn-primary mb-3 mb-md-0">{{allow}}</a></div><div class="col-12 col-md-6"><a aria-label="allow cookies" role="button" tabindex="1" class="cc-btn cc-allowall btn btn-block btn-primary">{{allowAll}}</a></div></div>',
                sgmessagelink: '<div id="cookieconsent:desc" class="cc-message">' +
                    '<h1>{{header}}</h1>' +
                    '{{message}} ' +
                    '<a aria-label="learn more about cookies" role=button tabindex="0" class="cc-link" href="{{href}}" rel="noopener noreferrer nofollow" target="{{target}}">{{link}}</a>' +
                    '<div class="sg--cookie-check">' +
                    '<label for="sg--cookie-require"><input type="checkbox" id="sg--cookie-require" class="sg--check-box" disabled="disabled" checked="checked"> {{sgRequire}}</label>' +
                    '<label for="sg--cookie-statistics"><input type="checkbox" id="sg--cookie-statistics" class="sg--check-box" > {{sgStatistik}}</label>' +
                    '<label for="sg--cookie-marketing"><input type="checkbox" id="sg--cookie-marketing" class="sg--check-box" > {{sgMarketing}}</label>' +
                    '</div>' +
                    '</div>',
            },

            onPopupOpen: function () {
                // set Body Class
                (new CookieConsent()).setClass();
                // load Checkboxes
                (new CookieConsent()).loadCheckboxes();
            },
            onPopupClose: function () {
                // remove Body Class
                (new CookieConsent()).setClass(true);
            },
            onInitialise: function (status) {
                if (this.hasConsented() && (status == 'dismiss' || status == 'allow')) (new CookieConsent()).loadCookies();
            },
            onStatusChange: function (status) {
                // save checkboxes?
                (new CookieConsent()).setCheckboxes();
                // load cookies
                if (this.hasConsented() && (status == 'dismiss' || status == 'allow')) (new CookieConsent()).loadCookies();
                // Remove the Node from HTML
                //if (window.cookieconsent_options.type == 'info' && !window.cookieconsent_options.revokable) this.element.parentNode.removeChild(this.element);
            },
            onRevokeChoice: function () {
            }
        });
        var allowAllButton = document.querySelector(".cc-allowall");
        allowAllButton.addEventListener("click", function(){
            document.getElementById("sg--cookie-statistics").checked = true;
            document.getElementById("sg--cookie-marketing").checked = true;
            document.querySelector(".cc-allow").click();
        }, false);
    };
    /** Init Handler **/
    var cookieHandler = new CookieConsent();
    /** Start Script Handling **/
    cookieHandler.load();
});
