<?php
namespace SG\Sitepackage\Hooks\PageLayoutView;

/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */

use \TYPO3\CMS\Backend\View\PageLayoutViewDrawItemHookInterface;
use \TYPO3\CMS\Backend\View\PageLayoutView;
use \TYPO3\CMS\Core\Utility\GeneralUtility;
use \TYPO3\CMS\Core\Database\ConnectionPool;

/**
 * Contains a preview rendering for the page module of CType="sg_sitepackage_card_slider"
 */
class CardSliderPreviewRenderer implements PageLayoutViewDrawItemHookInterface
{

    /**
     * Preprocesses the preview rendering of a content element of type "My new content element"
     *
     * @param \TYPO3\CMS\Backend\View\PageLayoutView $parentObject Calling parent object
     * @param bool $drawItem Whether to draw the item using the default functionality
     * @param string $headerContent Header content
     * @param string $itemContent Item content
     * @param array $row Record row of tt_content
     *
     * @return void
     */
    public function preProcess(
        PageLayoutView &$parentObject,
        &$drawItem,
        &$headerContent,
        &$itemContent,
        array &$row
    )
    {
        if ($row['CType'] === 'sg_sitepackage_card_slider') {

            $headerContent = '<strong>Card-Slider</strong>';


            $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_sg_sitepackage_card');

            $statement = $queryBuilder
                ->select('*')
                ->from('tx_sg_sitepackage_card')
                ->where(
                    $queryBuilder->expr()->eq('tt_content', $queryBuilder->createNamedParameter( (int) $row['uid'] ) )
                )
                ->execute();

            $elements = [];
            while ($item = $statement->fetch()) {
                $elements[] = $item;
            }

            // Fluid Template rendern
            /** @var \TYPO3\CMS\Fluid\View\StandaloneView $fluidTemplate */
            $fluidTemplateFilePath = \TYPO3\CMS\Core\Utility\GeneralUtility::getFileAbsFileName('EXT:sg_sitepackage/Resources/Private/Templates/ContentPreview/CardSlider.html');
            $fluidTemplate = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Fluid\View\StandaloneView');
            $fluidTemplate->setTemplatePathAndFilename($fluidTemplateFilePath);
            $fluidTemplate->assign('data', $row);
            $fluidTemplate->assign('items', $elements);

            // Rendern
            $itemContent = $parentObject->linkEditContent( $fluidTemplate->render(), $row );

            $drawItem = false;
        }
    }
}