<?php
$rsyncExcludes = array(
    'public/typo3conf/ext/sg_sitepackage/Resources/Public/Css',
    'public/typo3conf/ext/sg_sitepackage/Resources/Public/JavaScript',
    'public/typo3conf/ext/sg_sitepackage/Resources/Public/node_modules',
    'public/typo3conf/ext/sg_sitepackage/Resources/Public/gulpfile.js',
    'public/typo3conf/ext/sg_sitepackage/Resources/Public/package.json',
    'public/typo3conf/ext/sg_sitepackage/Resources/Public/package-lock.json',
    'public/typo3conf/ext/sg_sitepackage/Resources/Public/README.md',
    '.git',
    '.gitignore',
    '.surf'
);

$node = new \TYPO3\Surf\Domain\Model\Node($targetNodeConfiguration['name']);
$node->setHostname($targetNodeConfiguration['host']);
if ($targetNodeConfiguration['username'] != ''){
    $node->setOption('username', $targetNodeConfiguration['username']);
}

$application = new \TYPO3\Surf\Application\TYPO3\CMS($applicationConfiguration['name']);
$application->setContext('Production');
$application->setDeploymentPath($applicationConfiguration['deploymentPath']);
$application->setOption('webDirectory', 'public');
$application->setOption('composerCommandPath', '/usr/local/bin/composer');
$application->setOption('keepReleases', $applicationConfiguration['keepReleases']);
$application->setOption('repositoryUrl', $applicationConfiguration['repositoryUrl']);
if ($applicationConfiguration['branch'] != ''){
    $application->setOption('branch', $applicationConfiguration['branch']);
}
$application->setOption('transferMethod', 'rsync');
$application->setOption('packageMethod', 'git');
$application->setOption('updateMethod', NULL);
$application->setOption('verbose', false);
$application->setOption('rsyncExcludes', $rsyncExcludes);
$application->setOption('logOutput', true);
$application->setOption('hardClean', true);
$application->addNode($node);

$workflow = new \TYPO3\Surf\Domain\Model\SimpleWorkflow();
$workflow->setEnableRollback(false);

$workflow->defineTask('smply:buildStyling',
    'TYPO3\\Surf\\Task\\LocalShellTask',
    array('command' => array(
        'cd {workspacePath}/public/typo3conf/ext/sg_sitepackage/Resources/Public/',
        'npm prune',
        'npm install',
        'npm run build'
    ))
);
$workflow->defineTask('Helhum\\TYPO3\\Distribution\\DefinedTask\\EnvAwareTask', 'TYPO3\\Surf\\Task\\ShellTask', array(
    'command' => array(
        "cp {sharedPath}/.env {releasePath}/.env",
        "cd {releasePath}",
    )
));
$workflow->defineTask('Helhum\\TYPO3\\Distribution\\DefinedTask\\HtaccessAwareTask', 'TYPO3\\Surf\\Task\\ShellTask', array(
    'command' => array(
        "cp {sharedPath}/.htaccess {releasePath}/public/.htaccess",
        "cd {releasePath}",
    )
));

$workflow->beforeStage('transfer', 'smply:buildStyling');
$workflow->afterTask('TYPO3\\Surf\\Task\\Generic\\CreateSymlinksTask', 'Helhum\\TYPO3\\Distribution\\DefinedTask\\EnvAwareTask');
$workflow->afterTask('Helhum\\TYPO3\\Distribution\\DefinedTask\\EnvAwareTask', 'Helhum\\TYPO3\\Distribution\\DefinedTask\\HtaccessAwareTask');

$deployment->setWorkflow($workflow);
$deployment->setOption('phpBinaryPathAndFilename', '/usr/local/php/bin/php_cli');
$deployment->addApplication($application);