<?php

namespace SG\SgRedirects\Controller;

use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;

define('DATE', date("Y-m-d_H-i"));

class ManagementController extends ActionController {

	static $table 		= 'sys_redirect';
	static $dst 		= 'Redirects_'.DATE.'.csv';
    static $src 		= PATH_site.'typo3temp/tmp.csv';
    static $delimiter   = ';'; 
    static $enclosure   = '"';
    static $escape      = '"';
    static $maxlength 	= 1500;
	static $chnk 		= 1 * 1024 * 1024;
    
	static function get() {
		$query 	= GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(self::$table);
		return $query->select('*')->from(self::$table)->execute()->fetchAll();
	}

    static function transport($src, $dst) {
		$res = fopen($src, 'r');
		header('Content-Description: File Transfer');
		$inf = finfo_open(FILEINFO_MIME_TYPE);
		header('Content-Type: ' . finfo_file($inf, $src));
		$inf = finfo_open(FILEINFO_MIME_ENCODING);
		header('Content-Transfer-Encoding: '.finfo_file($inf, $src));
		header('Content-Disposition: attachment; filename="' . $dst . '"');
		while(!feof($res)) {
			echo fread($res, self::$chnk); // save allowed memory (if to many rows !!!)
			ob_flush();
		}
		exit;
	}

	static function update($path) {
		$affected = 0;
		$query 	= GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(self::$table);
		foreach(self::reader($path) as $k=>$v) 
			if($k > 0) 
				if($query->update(self::$table)
				->where($query->expr()->eq(		'uid', 			$query->createNamedParameter(intval(	$v[0]	), \PDO::PARAM_INT	))
				)->andWhere($query->expr()->eq(	'source_host', 	$query->createNamedParameter(			$v[1]	))
				)->andWhere($query->expr()->eq(	'source_path', 	$query->createNamedParameter(			$v[2]	)))
				->set('is_regexp', 			intval(	$v[3]	))
				->set('force_https', 		intval(	$v[4]	))
				->set('target', 					$v[5]	)
				->set('target_statuscode', 	intval(	$v[6]	))
				->execute()) $affected++;
		return $affected;
	}

	static function reader($path) {
		$ar = array();
		if(($h = fopen($path, "r")) !== false) {
			$i=0;
			while(($data = fgetcsv($h, self::$maxlength, self::$delimiter, self::$enclosure, self::$escape)) !== false) {
				$ar[$i] = $data;
				$i++;
			}
			fclose($h);
		}
		return $ar;
	}

	static function down() {
		$data 	= array();
		$res 	= fopen(self::$src, 'w');
		foreach(self::get() as $k=>$v) {
			$data[$k]['uid'] 				= $v['uid'];
			$data[$k]['source_host'] 		= $v['source_host'];
			$data[$k]['source_path'] 		= $v['source_path'];
			$data[$k]['is_regexp'] 			= $v['is_regexp'];
			$data[$k]['force_https'] 		= $v['force_https'];
			$data[$k]['target'] 			= $v['target'];
			$data[$k]['target_statuscode'] 	= $v['target_statuscode'];
			if($k == 0) 
				fputcsv($res, array_keys($data[$k]), self::$delimiter, self::$enclosure, self::$escape);
			fputcsv($res, array_values($data[$k]), self::$delimiter, self::$enclosure, self::$escape);
		}
		fclose($res);
		self::transport(self::$src, self::$dst);
	}

    public function indexAction() {
		if($this->request->hasArgument('uploadValues')) {
			$tmp = $this->request->getArguments();
			$affected = self::update($tmp['upload']['file']['tmp_name']); 
			$this->addFlashMessage($affected . ' - '. ($affected == 1 ? '"Redirect" ist' : '"Redirects" sind') . ' aktualisiert!');
		}
		if($this->request->hasArgument('downloadValues')) 
			self::down();
		$this->view->assign('total', count(self::get()));
    }

}



