window.SGPrivacy = (function(){
    var _init = false;
    var app = {};
    var settings = {
        cookieName: "klaro",
        debug: 1,
        controller: 'sg_privacy_ajax',
        url: 'index.php?eID=',
        method: 'POST',
        log: 0
    };

    app.init = function(options){
        if (_init) {
            return;
        }
        _init = true;

        settings = $.extend(settings, options);
    }

    app.send = function(obj){
        $.ajax({
            type:settings.method,
            url:settings.url+settings.controller,
            data:{
                cookies: obj,
                debug:settings.debug,
                domain:window.location.hostname,
                log:settings.log
            },
            success:function(msg){
                if(settings.debug) console.log(msg);
            }
        });
    };

    return app;
})();

/*
// init in main.js
$( document ).ready( function()
{
    SGPrivacy.init();
    var manager = klaro.getManager();
    manager.watch({
        update: function(manager, eventType, data){
            if (eventType === 'applyConsents'){
                SGPrivacy.send(data);
            }
        }
    });
});
*/