<?php
namespace SG\SgPrivacy\Ajax;

use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

class EidDispatcher
{
	protected $table = 'tx_sg_privacy';
	
    /**
     * BE for ajax 
     *
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @return ResponseInterface
     */
    public function processRequest(ServerRequestInterface $request, ResponseInterface $response)
    {
		$pre 		= $request->getParsedBody();
		$cookies 	= json_decode($pre['cookies'], true);
		$debug 		= $pre['debug'];
		$domain 	= $pre['domain'];
        if(count($cookies))
			$this->setStatistic($cookies, $domain);
		if($debug) {
			$response->getBody()->write( print_r($request->getParsedBody(), true) );
			return $response;
		}
		return null;
    }
	
    /**
     * @param Array $data
     * @param String $domain
     * @return void
     */
    protected function setStatistic($data, $domain)
    {
		$test 	= $this->insertOrUpdate($domain);

		if(!isset($test['data'])) {
			$func = function($value) { return $value ? 1 : 0; };
			$data = array_map($func, $data);
			$data = array_reverse($data);
			$data['Total'] = 1;
			$data = array_reverse($data);
            $GLOBALS['TYPO3_DB']->exec_INSERTquery($this->table, [
                'year' 		=> date("Y"),
                'month' 	=> date("m"),
                'data' 		=> serialize($data),
                'domain' 	=> $domain
            ]);
		} else {
			$arr = unserialize($test['data']);
			$newData = array();
			foreach($data as $k=>$v){
                if ($v == 1){
                    $newData[$k] = in_array($k, array_keys($arr)) ? $arr[$k]+1 : 1;
                }else{
                    $newData[$k] = in_array($k, array_keys($arr)) ? $arr[$k] : 0;
                }
            }

			$newData = array_reverse($newData);
			$newData['Total'] = $arr['Total'] + 1;
			$newData = array_reverse($newData);
			$where = 'year = "'.date("Y").'" AND month="'.date('n').'" AND domain="'.$domain.'"';
            $GLOBALS['TYPO3_DB']->exec_UPDATEquery(
                $this->table,
                $where,
                ['data' => serialize($newData)]
            );
		}
    }

    /**
     * @param $domain
     * @return array
     */
	protected function insertOrUpdate($domain)
    {
        $where = 'year = "' . date("Y") . '" AND month = "'.date('n').'" AND domain = "'. $domain.'"';
        $result = $GLOBALS['TYPO3_DB']->exec_SELECTquery('*', $this->table, $where, '', '',1);

        /**
         * @var $result \mysqli_result
         */
        if ($result->num_rows >= 1) {
            return $result->fetch_assoc();
        }
        return [];
    }
}
