window.SGPrivacy = (function(){
    var _init = false;
    var app = {};
    var settings = {
        cookieName: "klaro",
        debug: 0,
        controller: 'sg_privacy_ajax',
        url: 'index.php?eID=',
        method: 'POST',
        log: 0
    };

    app.init = function(options){
        if (_init) {
            return;
        }
        _init = true;

        settings = $.extend(settings, options);
    }

    app.send = function(){
        $.ajax({
            type:settings.method,
            url:settings.url+settings.controller,
            data:{
                cookies:document.cookie.split(/; */).reduce(function(obj,str){
                    if(str==="") return obj;
                    var eq = str.indexOf('=');
                    var key = eq>0 ? str.slice(0,eq) : str;
                    var val = eq>0 ? str.slice(eq+1) : null;
                    if (val!=null) try{val=decodeURIComponent(val);}catch(ex){}
                    if(key==settings.cookieName) return val;
                }, {}),
                debug:settings.debug,
                domain:window.location.hostname,
                log:settings.log
            },
            success:function(msg){
                if(settings.debug) console.log(msg);
            }
        });
    };

    return app;
})();

$( document ).ready( function()
{
    SGPrivacy.init();
    var manager = klaro.getManager();
    manager.watch({
        update: function(manager, eventType, data){
            if (eventType === 'applyConsents'){
                SGPrivacy.send();
            }
        }
    });
});