<?php

namespace SG\SgPrivacy\Controller;

use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class PrivacyController extends ActionController {

	protected $table 		= 'tx_sg_privacy';
	protected $tableLog 	= 'tx_sg_privacy_log';
	protected $dst 			= 'log.csv';
	protected $src 			= PATH_site.'typo3temp/tmp.csv';
    protected $delimiter   	= ';'; 
    protected $enclosure   	= '"';
    protected $escape      	= '"';
    protected $chnk 		= 1 * 1024 * 1024; // can be big
    
	/**
	 * Show Statistics table
	 *
	 */
    public function indexAction()
    {
		$logCount = 0;
		$query 	= GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable($this->tableLog);
		$logCount = count($query->select('*')->from($this->tableLog)->execute()->fetchAll()); // sorry
		// $query->select('COUNT(*)') - not supported
		// SELECT TABLE_ROWS FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = ' . $this->tableLog - (time: ~0.0001, rows qty independ.)
		$data 	= array();
		$query 	= GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable($this->table);
		foreach($query->select('*')->from($this->table)->execute()->fetchAll() as $k=>$v) {
			$data[$k]['year'] 		= $v['year'];
			$data[$k]['month'] 		= $v['month'];
			$data[$k]['domain'] 	= $v['domain'];
			$data[$k]['data'] 		= unserialize($v['data']);
		}
		$this->view->assign('statisticsAssign', $data);
		$this->view->assign('logCount', $logCount);
    }

	public function downloadAction() {
        $query 	= GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable($this->tableLog);
        $res = fopen($this->src, 'w');
        foreach($query->select('*')->from($this->tableLog)->execute()->fetchAll() as $row) 
			fputcsv($res, $row, $this->delimiter, $this->enclosure, $this->escape);
        fclose($res);
		$res = fopen($this->src, 'r');
		header('Content-Description: File Transfer');
		$inf = finfo_open(FILEINFO_MIME_TYPE);
		header('Content-Type: ' . finfo_file($inf, $this->src));
		$inf = finfo_open(FILEINFO_MIME_ENCODING);
		header('Content-Transfer-Encoding: '.finfo_file($inf, $this->src));
		header('Content-Disposition: attachment; filename="' . $this->dst . '"');
		while(!feof($res)) {
			echo fread($res, $this->chnk); // save allowed memory
			ob_flush();
		}
		exit;
    }

}
