<?php
namespace SG\SgPrivacy\Ajax;

use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class EidDispatcher
{
	protected $table 	= 'tx_sg_privacy';
	protected $tableLog = 'tx_sg_privacy_log';
	
    /**
     * BE for ajax 
     *
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @return ResponseInterface
     */
    public function processRequest(ServerRequestInterface $request, ResponseInterface $response): ResponseInterface
    {
		$pre 		= $request->getParsedBody();
		$cookies 	= json_decode($pre['cookies'], true);
		$debug 		= $pre['debug'];
		$domain 	= $pre['domain'];
		$log 		= $pre['log'];
        if(count($cookies)) 
			$this->setStatistic($cookies, $domain, $log);
		if($debug > 0) 
			$response->getBody()->write(print_r($request->getParsedBody(), true));
		return $response;
    }
	
    protected function getIp(): string
    {
		$ip = '0.0.0.0';
		if(!empty($_SERVER['HTTP_CLIENT_IP'])) 
			$ip = $_SERVER['HTTP_CLIENT_IP'];
		elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) 
			$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
		else 
			$ip = $_SERVER['REMOTE_ADDR'];
		return $ip;
    }	
	
    protected function setLog($data, $domain): void
    {
		$query 	= $this->getConnectionPool()->getQueryBuilderForTable($this->tableLog);
		$query->insert($this->tableLog)->values([
				'ip' 		=> $this->getIp(),
				'data' 		=> serialize($data),
				'domain' 	=> $domain
		])->execute();
    }
	
    /**
     * @param Array $data
     * @param String $domain
     * @param Integer $log
     * @return void
     */
    protected function setStatistic($data, $domain, $log=0): void
    {
		$query 	= $this->getConnectionPool()->getQueryBuilderForTable($this->table);
		$test 	= $this->insertOrUpdate($domain);
		if(!count($test)) {
			$func = function($value) { return $value ? 1 : 0; };
			$data = array_map($func, $data);
			$data = array_reverse($data);
			$data['Total'] = 1;
			$data = array_reverse($data);
			$query->insert($this->table)->values([
				'year' 		=> date("Y"),
				'month' 	=> date("m"),
				'data' 		=> serialize($data),
				'domain' 	=> $domain
			])->execute();
			if($log > 0) $this->setLog($data, $domain);
		} else {
			$arr = unserialize($test[0]['data']);
			$newData = array();
            foreach($data as $k=>$v){
                if ($v == 1){
                    $newData[$k] = in_array($k, array_keys($arr)) ? $arr[$k]+1 : 1;
                }else{
                    $newData[$k] = in_array($k, array_keys($arr)) ? $arr[$k] : 0;
                }
            }
			$newData = array_reverse($newData);
			$newData['Total'] = $arr['Total'] + 1;
			$newData = array_reverse($newData);
			$query->update($this->table)
			->where(
				$query->expr()->eq('year', 		date("Y")),
				$query->expr()->eq('month', 	str_replace('0', '', date("m"))), 
				$query->expr()->eq('domain', 	"'" . $domain . "'")
			)->set('data', serialize($newData))->execute();
			if($log > 0) $this->setLog($newData, $domain);
		}
    }

	protected function insertOrUpdate($domain): array
    {
        $query 	= $this->getConnectionPool()->getQueryBuilderForTable($this->table);
        $rows 	= $query->select('*')->from($this->table)
            ->where(
				$query->expr()->eq('year', 		date("Y")),
				$query->expr()->eq('month', 	str_replace('0', '', date("m"))),
				$query->expr()->eq('domain', 	"'" . $domain . "'")
            )->execute()->fetchAll();
        if (!$rows) {
            $rows = [];
        }
        return $rows;
    }

    protected function getConnectionPool(): ConnectionPool
    {
        return GeneralUtility::makeInstance(ConnectionPool::class);
    }
}
