<?php
namespace SG\SgImmoservice\Domain\Repository;

use SG\SgImmoservice\Domain\Model\CompetentAuthority;
use TYPO3\CMS\Extbase\Persistence\Repository;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;

/**
 * The repository for CompetentAuthorities
 */
class CompetentAuthorityRepository extends Repository {

    /**
     * Initializefunction
     */
    public function initializeObject(){
        /** @var $querySettings Typo3QuerySettings */
        $querySettings = $this->objectManager->get('TYPO3\\CMS\\Extbase\\Persistence\\Generic\\Typo3QuerySettings');
        $querySettings->setRespectStoragePage(FALSE);
        $this->setDefaultQuerySettings($querySettings);
    }

    /**
     * Function returns an array for mapping the correct entities in Importtask
     *
     * @return array
     */
    public function getImportMatrix(){
        $allCompetentAuthorities = $this->findAll();
        $importMatrix = array();
        foreach ($allCompetentAuthorities as $competentAuthority){
            /**
             * @var $competentAuthority CompetentAuthority
             */
            $importMatrix[$competentAuthority->getExternalId()] = $competentAuthority->getUid();
        }
        return $importMatrix;
    }
}