<?php
namespace SG\SgImmoservice\Domain\Repository;

use SG\SgImmoservice\Domain\Model\CompetenceType;
use TYPO3\CMS\Extbase\Persistence\Repository;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;

/**
 * The repository for CompetenceTypes
 */
class CompetenceTypeRepository extends Repository {

    /**
     * Initializefunction
     */
    public function initializeObject(){
        /** @var $querySettings Typo3QuerySettings */
        $querySettings = $this->objectManager->get('TYPO3\\CMS\\Extbase\\Persistence\\Generic\\Typo3QuerySettings');
        $querySettings->setRespectStoragePage(FALSE);
        $this->setDefaultQuerySettings($querySettings);
    }

    /**
     * Function returns an array for mapping the correct entities in Importtask
     *
     * @return array
     */
    public function getImportMatrix(){
        $allCompetenceTypes = $this->findAll();
        $importMatrix = array();
        foreach ($allCompetenceTypes as $competenceType){
            /**
             * @var $competenceType CompetenceType
             */
            $importMatrix[$competenceType->getExternalId()] = $competenceType->getUid();
        }
        return $importMatrix;
    }
}