<?php
namespace SG\SgImmoservice\Domain\Repository;

use SG\SgImmoservice\Domain\Model\ResidentialUnit;
use TYPO3\CMS\Extbase\Persistence\Repository;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;

/**
 * The repository for ResidentialUnits
 * @method ResidentialUnit findOneByExternalId(string $value)
 */
class ResidentialUnitRepository extends Repository {

    /**
     * Initializefunction
     */
    public function initializeObject(){
        /** @var $querySettings Typo3QuerySettings */
        $querySettings = $this->objectManager->get('TYPO3\\CMS\\Extbase\\Persistence\\Generic\\Typo3QuerySettings');
        $querySettings->setRespectStoragePage(FALSE);
        $this->setDefaultQuerySettings($querySettings);
    }

    /**
     * Function returns an array for mapping the correct entities in Importtask
     *
     * @return array
     */
    public function getImportMatrix(){
        $allResidentialUnits = $this->findAll();
        $importMatrix = array();
        foreach ($allResidentialUnits as $residentialUnit){
            /**
             * @var $residentialUnit ResidentialUnit
             */
            $importMatrix[$residentialUnit->getExternalId()] = $residentialUnit->getUid();
        }
        return $importMatrix;
    }
}