<?php
namespace SG\SgImmoservice\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\Repository;
use SG\SgImmoservice\Domain\Model\ContactPerson;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;

/**
 * The repository for ContactPersons
 */
class ContactPersonRepository extends Repository {

    /**
     * Initializefunction
     */
    public function initializeObject(){
        /** @var $querySettings Typo3QuerySettings */
        $querySettings = $this->objectManager->get('TYPO3\\CMS\\Extbase\\Persistence\\Generic\\Typo3QuerySettings');
        $querySettings->setRespectStoragePage(FALSE);
        $this->setDefaultQuerySettings($querySettings);
    }

    /**
     * Function returns an array for mapping the correct entities in Importtask
     *
     * @return array
     */
    public function getImportMatrix(){
        $allContactPersons = $this->findAll();
        $importMatrix = array();
        foreach ($allContactPersons as $contactPerson){
            /**
             * @var $contactPerson ContactPerson
             */
            $importMatrix[$contactPerson->getExternalId()] = $contactPerson->getUid();
        }
        return $importMatrix;
    }
}