<?php
namespace SG\SgImmoservice\Controller;

use TYPO3\CMS\Core\Cache\CacheManager;
use TYPO3\CMS\Core\Cache\Frontend\FrontendInterface;
use TYPO3\CMS\Core\Database\Query\QueryBuilder;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Database\ConnectionPool;
use stdClass;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use SG\SgImmoservice\Domain\Repository\ResidentialUnitRepository;
use SG\SgImmoservice\Domain\Repository\ResponsibilityContactPersonRepository;
use SG\SgImmoservice\Domain\Repository\ResponsibilityCompetentAuthorityRepository;
use SG\SgImmoservice\Domain\Model\ResidentialUnit;
use SG\SgImmoservice\Domain\Model\ServiceUnit;
use TYPO3\CMS\Extbase\Persistence\Generic\QueryResult;
use TYPO3\CMS\Extbase\Mvc\Exception\NoSuchArgumentException;

/**
 * SearchController
 */
class SearchController extends ActionController {

    /**
     * @var ResidentialUnitRepository
     */
    protected $residentialUnitRepository;

    /**
     * @param ResidentialUnitRepository $residentialUnitRepository
     */
    public function injectResidentialUnitRepository(ResidentialUnitRepository $residentialUnitRepository){
        $this->residentialUnitRepository = $residentialUnitRepository;
    }

    /**
     * @var ResponsibilityContactPersonRepository
     */
    protected $responsibilityContactPersonRepository;

    /**
     * @param ResponsibilityContactPersonRepository $responsibilityContactPersonRepository
     */
    public function injectResponsibilityContactPersonRepository(ResponsibilityContactPersonRepository $responsibilityContactPersonRepository){
        $this->responsibilityContactPersonRepository = $responsibilityContactPersonRepository;
    }

    /**
     * @var ResponsibilityCompetentAuthorityRepository
     */
    protected $responsibilityCompetentAuthorityRepository;

    /**
     * @param ResponsibilityCompetentAuthorityRepository $responsibilityCompetentAuthorityRepository
     */
    public function injectResponsibilityCompetentAuthorityRepository(ResponsibilityCompetentAuthorityRepository $responsibilityCompetentAuthorityRepository){
        $this->responsibilityCompetentAuthorityRepository = $responsibilityCompetentAuthorityRepository;
    }

    /**
     * @var FrontendInterface
     */
    protected $cache;

    /**
     * @var array
     */
    protected $cities;

    /**
     * Initialize cache instance to be ready to use
     *
     * @return void
     */
    protected function initializeCache() {
        $this->cache = GeneralUtility::makeInstance(CacheManager::class)->getCache('sgimmoservice_cache');
    }

    public function __construct(){
        $this->initializeCache();
        $this->cities = $this->getCities();
    }


    /**
     * @return mixed|string
     */
    public function indexAction(){
        /**
         * @var $residentialUnit ResidentialUnit
         * @var $serviceUnit ServiceUnit
         * @var $responsibilitiesInternal QueryResult
         */
        if ($this->request->hasArgument('formValues')){
            $requestArguments = $this->request->getArguments();
            $formValues = $requestArguments['formValues'];

            $cacheIdentifier = 'sgimmoservice_detail_'.sha1($formValues['street']);
            if (($entry = $this->cache->get($cacheIdentifier)) === FALSE) {
                $this->view->assign('formValues', $formValues);
                $this->view->assign('streets', $this->getStreets($formValues['city']));
                $this->view->assign('selectedCity', $formValues['city']);

                $residentialUnit = $this->residentialUnitRepository->findOneByExternalId($formValues['street']);
                if ($residentialUnit instanceof ResidentialUnit){
                    $serviceUnit = $residentialUnit->getServiceUnit();

                    $this->view->assign('responsibilitiesInternal', $this->responsibilityContactPersonRepository->findByResidentialUnit($residentialUnit));
                    $this->view->assign('responsibilitiesExternal', $this->responsibilityCompetentAuthorityRepository->findByResidentialUnit($residentialUnit));

                    $this->view->assign('residentialUnit', $residentialUnit);
                    $this->view->assign('serviceUnit', $serviceUnit);
                }


                $this->view->assign('cities', $this->cities);

                $entry = $this->view->render();

                $this->cache->set($cacheIdentifier, $entry, array(), $this->settings['defaultCacheLifetime']);
            }
            return $entry;
        }
        $this->view->assign('cities', $this->cities);
        return $this->view->render();
    }

    /**
     * @throws NoSuchArgumentException
     */
    public function ajaxAction(){
        $requestType = GeneralUtility::_POST('requestType');
        if ($requestType != ''){
            switch ($requestType){
                case 'getCities':
                    $this->view->assign('jsonValue', json_encode($this->getCities()));
                    break;
                case 'getStreets':
                    $city = GeneralUtility::_POST('city');
                    $this->view->assign('jsonValue', json_encode($this->getStreets($city)));
                    break;
                default:
                    break;
            }
        }
    }

    /**
     *
     * Generates City Array from Cache or Databse
     *
     * @return array
     */
    private function getCities(){
        $cacheIdentifier = 'sgimmoservice_cities';

        if (($entry = $this->cache->get($cacheIdentifier)) === FALSE) {
            /**
             * @var $queryBuilderResidentialUnits QueryBuilder
             */
            $queryBuilderResidentialUnits = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_sgimmoservice_domain_model_residentialunit');
            $statement = $queryBuilderResidentialUnits
                ->select('city')
                ->from('tx_sgimmoservice_domain_model_residentialunit')
                ->groupBy('city')
                ->orderBy('city')
                ->execute();

            $entry = array();
            while ($row = $statement->fetch()) {
                $entry[] = $row['city'];
            }

            $this->cache->set($cacheIdentifier, $entry, array(), $this->settings['defaultCacheLifetime']);
        }
        return $entry;
    }


    private function getStreets($city){
        $cacheIdentifier = 'immoservice_streets_'.sha1($city);

        if (($entry = $this->cache->get($cacheIdentifier)) === FALSE) {
            /**
             * @var $queryBuilderResidentialUnits QueryBuilder
             */
            $queryBuilderResidentialUnits = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_sgimmoservice_domain_model_residentialunit');
            $statement = $queryBuilderResidentialUnits
                ->select('external_id','street')
                ->from('tx_sgimmoservice_domain_model_residentialunit')
                ->where(
                    $queryBuilderResidentialUnits->expr()->eq('city', $queryBuilderResidentialUnits->createNamedParameter($city))
                )
                ->groupBy('street')
                ->orderBy('street')
                ->execute();
            $entry = array();
            while ($row = $statement->fetch()) {
                $temp = new stdClass();
                $temp->externalId = $row['external_id'];
                $temp->street = $row['street'];
                $entry[] = $temp;
            }
            $this->cache->set($cacheIdentifier, $entry, array(), $this->settings['defaultCacheLifetime']);
        }
        return $entry;
    }
}