<?php
namespace SG\SgImmoservice\Domain\Repository;

use SG\SgImmoservice\Domain\Model\ServiceUnit;
use TYPO3\CMS\Extbase\Persistence\Repository;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;

/**
 * The repository for ServiceUnits
 */
class ServiceUnitRepository extends Repository {

    public function initializeObject(){
        /** @var $querySettings Typo3QuerySettings */
        $querySettings = $this->objectManager->get('TYPO3\\CMS\\Extbase\\Persistence\\Generic\\Typo3QuerySettings');
        $querySettings->setRespectStoragePage(FALSE);
        $this->setDefaultQuerySettings($querySettings);
    }

    /**
     * Function returns an array for mapping the correct entities in Importtask
     *
     * @return array
     */
    public function getImportMatrix(){
	    $allServiceUnits = $this->findAll();
	    $importMatrix = array();
	    foreach ($allServiceUnits as $serviceUnit){
            /**
             * @var $serviceUnit ServiceUnit
             */
	        $importMatrix[$serviceUnit->getExternalId()] = $serviceUnit->getUid();
        }
	    return $importMatrix;
    }
}