<?php
namespace SG\SgImmoservice\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

/**
 * ResidentialUnit
 */
class ResidentialUnit extends AbstractEntity {

	/**
	 * externalId
	 *
	 * @var string
	 */
	protected $externalId = '';

	/**
	 * street
	 *
	 * @var string
	 */
	protected $street = '';

	/**
	 * houseNumber
	 *
	 * @var string
	 */
	protected $houseNumber = '';

	/**
	 * zip
	 *
	 * @var string
	 */
	protected $zip = '';

	/**
	 * city
	 *
	 * @var string
	 */
	protected $city = '';

	/**
	 * district
	 *
	 * @var string
	 */
	protected $district = '';

	/**
	 * serviceUnit
	 *
	 * @var \SG\SgImmoservice\Domain\Model\ServiceUnit
	 */
	protected $serviceUnit = NULL;

	/**
	 * Returns the externalId
	 *
	 * @return string $externalId
	 */
	public function getExternalId() {
		return $this->externalId;
	}

	/**
	 * Sets the externalId
	 *
	 * @param string $externalId
	 * @return void
	 */
	public function setExternalId($externalId) {
		$this->externalId = $externalId;
	}

	/**
	 * Returns the street
	 *
	 * @return string $street
	 */
	public function getStreet() {
		return $this->street;
	}

	/**
	 * Sets the street
	 *
	 * @param string $street
	 * @return void
	 */
	public function setStreet($street) {
		$this->street = $street;
	}

	/**
	 * Returns the houseNumber
	 *
	 * @return string $houseNumber
	 */
	public function getHouseNumber() {
		return $this->houseNumber;
	}

	/**
	 * Sets the houseNumber
	 *
	 * @param string $houseNumber
	 * @return void
	 */
	public function setHouseNumber($houseNumber) {
		$this->houseNumber = $houseNumber;
	}

	/**
	 * Returns the zip
	 *
	 * @return string $zip
	 */
	public function getZip() {
		return $this->zip;
	}

	/**
	 * Sets the zip
	 *
	 * @param string $zip
	 * @return void
	 */
	public function setZip($zip) {
		$this->zip = $zip;
	}

	/**
	 * Returns the city
	 *
	 * @return string $city
	 */
	public function getCity() {
		return $this->city;
	}

	/**
	 * Sets the city
	 *
	 * @param string $city
	 * @return void
	 */
	public function setCity($city) {
		$this->city = $city;
	}

	/**
	 * Returns the district
	 *
	 * @return string $district
	 */
	public function getDistrict() {
		return $this->district;
	}

	/**
	 * Sets the district
	 *
	 * @param string $district
	 * @return void
	 */
	public function setDistrict($district) {
		$this->district = $district;
	}

	/**
	 * __construct
	 */
	public function __construct() {
		//Do not remove the next line: It would break the functionality
		$this->initStorageObjects();
	}

	/**
	 * Initializes all ObjectStorage properties
	 * Do not modify this method!
	 * It will be rewritten on each save in the extension builder
	 * You may modify the constructor of this class instead
	 *
	 * @return void
	 */
	protected function initStorageObjects() {
		
	}

	/**
	 * Returns the serviceUnit
	 *
	 * @return \SG\SgImmoservice\Domain\Model\ServiceUnit $serviceUnit
	 */
	public function getServiceUnit() {
		return $this->serviceUnit;
	}

	/**
	 * Sets the serviceUnit
	 *
	 * @param \SG\SgImmoservice\Domain\Model\ServiceUnit $serviceUnit
	 * @return void
	 */
	public function setServiceUnit(\SG\SgImmoservice\Domain\Model\ServiceUnit $serviceUnit) {
		$this->serviceUnit = $serviceUnit;
	}

}