<?php
namespace SG\SgImmoservice\Tasks;

use TYPO3\CMS\Scheduler\AbstractAdditionalFieldProvider;
use TYPO3\CMS\Scheduler\AdditionalFieldProviderInterface;
use TYPO3\CMS\Scheduler\Controller\SchedulerModuleController;
use TYPO3\CMS\Scheduler\Task\AbstractTask;
use TYPO3\CMS\Core\Messaging\FlashMessage;

class ImportAdditionalFieldProvider extends  AbstractAdditionalFieldProvider implements AdditionalFieldProviderInterface{

    /**
     * @param array $taskInfo
     * @param AbstractTask $task
     * @param SchedulerModuleController $schedulerModule
     * @return mixed
     */
    public function getAdditionalFields(array &$taskInfo, $task, SchedulerModuleController $schedulerModule)
    {
        $additionalFields['task_sgimmoserviceimport_storagepid']              = $this->getStoragePidAdditionalField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgimmoserviceimport_importfile']                    = $this->getImportFileAdditionalField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgimmoserviceimport_debugmode'] = $this->getDebugModeAdditionalField($taskInfo, $task, $schedulerModule);

        return $additionalFields;
    }

    /**
     * @param array $submittedData
     * @param SchedulerModuleController $schedulerModule
     * @return bool
     */
    public function validateAdditionalFields(array &$submittedData, SchedulerModuleController $schedulerModule)
    {
        $validData = $this->validateStoragePidAdditionalField($submittedData);

        return $validData;
    }

    /**
     * @param array $submittedData
     * @param AbstractTask $task
     */
    public function saveAdditionalFields(array $submittedData, AbstractTask $task)
    {
        /**
         * @var $task \SG\SgImmoservice\Tasks\Import
         */

        $task->setStoragePid((int)$submittedData['task_sgimmoserviceimport_storagepid']);
        $task->setImportFile($submittedData['task_sgimmoserviceimport_importfile']);
        $task->setDebugMode($submittedData['task_sgimmoserviceimport_debugmode'] == 1 ? true : false);
    }


    /**
     * @param array $taskInfo
     * @param $task
     * @param SchedulerModuleController $schedulerModule
     * @return array
     */
    public function getImportFileAdditionalField(array &$taskInfo, $task, SchedulerModuleController $schedulerModule){
        /**
         * @var $task \SG\SgImmoservice\Tasks\Import
         */

        if (empty($taskInfo['task_sgimmoserviceimport_importfile'])) {
            if ($schedulerModule->getCurrentAction() == 'add') {
                $taskInfo['task_sgimmoserviceimport_importfile'] = null;
            } elseif ($schedulerModule->getCurrentAction() == 'edit') {
                $taskInfo['task_sgimmoserviceimport_importfile'] = $task->getImportFile();
            }
        }

        $fieldName = 'tx_scheduler[task_sgimmoserviceimport_importfile]';
        $fieldId = 'task_sgimmoserviceimport_importfile';

        $reportTypes = array(
            'all' => '0. All Files',
            'residentialUnit' => '1. residentialUnit',
            'competentAuthority' => '2. competentAuthority',
            'contactPerson' => '3. contactPerson',
            'residentialUnitcompetentAuthority' => '4. residentialUnitcompetentAuthority'
        );

        $fieldHtml = '<select name="'.$fieldName.'" id="'.$fieldId.'">';
        foreach($reportTypes as $key => $value){
            $selected = '';
            if ((isset($taskInfo['task_sgimmoserviceimport_importfile']))&&($key == $taskInfo['task_sgimmoserviceimport_importfile'])){
                $selected = 'selected="selected"';
            }
            $fieldHtml .= '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
        }
        $fieldHtml .= '</select>';


        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Import File',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

    /**
     * @param array $taskInfo
     * @param $task
     * @param SchedulerModuleController $schedulerModule
     * @return array
     */
    protected function getStoragePidAdditionalField(array &$taskInfo, $task, SchedulerModuleController $schedulerModule) {
        /**
         * @var $task \SG\SgImmoservice\Tasks\Import
         */

        if (empty($taskInfo['task_sgimmoserviceimport_storagepid'])) {
            if ($schedulerModule->getCurrentAction() == 'add') {
                $taskInfo['task_sgimmoserviceimport_storagepid'] = 0;
            } elseif ($schedulerModule->getCurrentAction() == 'edit') {
                $taskInfo['task_sgimmoserviceimport_storagepid'] = $task->getStoragePid();
            }
        }

        $fieldName = 'tx_scheduler[task_sgimmoserviceimport_storagepid]';
        $fieldId = 'task_sgimmoserviceimport_storagepid';
        $fieldHtml = '<input type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . (int)$taskInfo['task_sgimmoserviceimport_storagepid'] . '" ' . 'size="4" />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'StoragePid',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

    /**
     * @param array $submittedData
     * @return bool
     */
    protected function validateStoragePidAdditionalField(array &$submittedData) {
        $validData = FALSE;
        if (!isset($submittedData['task_sgimmoserviceimport_storagepid'])) {
            $validData = TRUE;
        } elseif ((int)$submittedData['task_sgimmoserviceimport_storagepid'] > 0) {
            $validData = TRUE;
        } else {
            $this->addMessage('Bitte eine gültige PID eingeben!', FlashMessage::ERROR);
        }
        return $validData;
    }


    /**
     * @param array $taskInfo
     * @param $task
     * @param SchedulerModuleController $schedulerModule
     * @return array
     */
    protected function getDebugModeAdditionalField(array &$taskInfo, $task, SchedulerModuleController $schedulerModule){
        /**
         * @var $task \SG\SgImmoservice\Tasks\Import
         */
        if (empty($taskInfo['task_sgimmoserviceimport_debugmode'])) {
            if ($schedulerModule->getCurrentAction() == 'add') {
                $taskInfo['task_sgimmoserviceimport_debugmode'] = false;
            } elseif ($schedulerModule->getCurrentAction() == 'edit') {
                $taskInfo['task_sgimmoserviceimport_debugmode'] = $task->isDebugMode();
            }
        }

        if ($taskInfo['task_sgimmoserviceimport_debugmode']){
            $checkboxState = 'checked="checked"';
        }else{
            $checkboxState = '';
        }

        $fieldName = 'tx_scheduler[task_sgimmoserviceimport_debugmode]';
        $fieldId = 'task_sgimmoserviceimport_debugmode';
        $fieldHtml = '<input type="checkbox" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="1"' . $checkboxState . '" ' . ' />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'DebugMode',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }
}