<?php

namespace SG\SgImmobilieList\Controller;

use SG\SgImmobilieList\Domain\Model\Item;
use SG\SgImmobilieList\Domain\Repository\ItemRepository;
use TYPO3\CMS\Core\Cache\CacheManager;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Extbase\Mvc\Exception\NoSuchArgumentException;
use TYPO3\CMS\Extbase\Annotation\Inject;

class DisplayController extends ActionController {

    /**
     * itemRepository
     *
     * @inject
     * @var \SG\SgImmobilieList\Domain\Repository\ItemRepository
     */
    protected $itemRepository;

    /**
     * @var \TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer
     */
    private $contentObj;

    /**
     * @throws NoSuchArgumentException
     */
    public function indexAction() {



        if (empty($_POST['form_send']) || empty($_POST['immobilie_uid'])) {
/*
            $this->contentObj = $this->configurationManager->getContentObject();
            $cache = GeneralUtility::makeInstance(CacheManager::class)->getCache('sgimmobilielist_cache');
            $cacheIdentifier = 'sg-sgimmobilielist-'.$this->contentObj->data['uid'];
            $activeCategory = null;

            if (($entry = $cache->get($cacheIdentifier)) === FALSE) {
*/
                $items = $this->itemRepository->findAll();
                if ($items->count() > 0){
                    $this->view->assign('items', $items);
                }else{
                    $this->view->assign('error',1);
                    $this->view->assign('errorType','NO-ITEMS');
                }

                $this->view->assign('contentObjectUid', $this->contentObj->data['uid']);

                $entry = $this->view->render();

/*
                $tags = array();
                $lifetime = $this->settings['defaultCacheLifetime'];

                // Save value in cache
                $cache->set($cacheIdentifier, $entry, $tags, $lifetime);

            }
*/

            return $entry;

        } else {

//			file_put_contents('/tmp/smply.gd.txt', "send form\n\n\n", FILE_APPEND);

            $item = $this->itemRepository->findOneByUid($_POST['immobilie_uid']);

			if (!$item) return;

			$limits = (string)($item->getLimits() + 1);

			$item->setLimits($limits);

			$res = $this->itemRepository->update($item);






	        /**
	         * @var $emailView StandaloneView
	         * @var $message MailMessage
	         */
	        $objectManager = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Object\ObjectManager');

	        $extSgImmobilieListFrameworkConfiguration = $this->configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_FRAMEWORK);

	        $emailView = $objectManager->get('TYPO3\CMS\Fluid\View\StandaloneView');
	        $emailView->setTemplateRootPaths($extSgImmobilieListFrameworkConfiguration['view']['templateRootPaths']);
	        $emailView->setPartialRootPaths($extSgImmobilieListFrameworkConfiguration['view']['partialRootPaths']);
	        $emailView->setLayoutRootPaths($extSgImmobilieListFrameworkConfiguration['view']['layoutRootPaths']);
	        $emailView->setTemplate('Email/SgImmobilieListForm');

	        $emailView->setFormat('html');
	        $emailView->assignMultiple($_POST + ['itemName' => $item->getName()]);

	        $emailBody = $emailView->render();



	        $message = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Core\Mail\MailMessage');




	        if (\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($this->settings['contact']['sender'])) {
	            $message->setFrom($this->settings['contact']['sender']);
	        }

	        // Add Recipients
	        $recipients = array_filter(explode(',', $this->settings['contact']['receivers']));
	        if (count($recipients) > 0) {
	            foreach ($recipients as $email) {
	                if (\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($email)) {
	                    $message->addTo($email);
	                }
	            }
	        } else {
	            return false;
	        }


	        if ($this->settings['contact']['subject'] != '') {
	            $message->setSubject($this->settings['contact']['subject'].". Immobilien: ".$item->getName());
	        } else {
	            $message->setSubject("Nachricht aus dem Formular. Immobilien: ".$item->getName());
	        }



			if (!empty($_FILES['file1']))  {
				if (!empty($_FILES['file1']['tmp_name'])) {
					foreach ($_FILES['file1']['tmp_name'] AS $key => $fileTmpName) {
						if (!empty($fileTmpName)) {
							$message->attachFromPath($fileTmpName, $_FILES['file1']['name'][$key]);
						}
					}
				}
			}




	        $message->html($emailBody);



	        $message->send();
//	        return $message->isSent();





			return $this->redirectToUri('danke');


        }

   }
}