<?php
namespace SG\SgImmobilieList\Domain\Model;

use TYPO3\CMS\Extbase\Annotation as Extbase;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class Item extends AbstractEntity {

	/**
	 * name
	 *
	 * @var string
	 * @Extbase\Validate("NotEmpty")
	 */
	protected $name;

	/**
	 * lage
	 *
	 * @var string
	 * @Extbase\Validate("NotEmpty")
	 */
	protected $lage;

	/**
	 * finanzierung
	 *
	 * @var string
	 * @Extbase\Validate("NotEmpty")
	 */
	protected $finanzierung;

	/**
	 * limits
	 *
	 * @var integer
	 * @Extbase\Validate("NotEmpty")
	 */
	protected $limits;

	/**
	 * zimmer
	 *
	 * @var integer
	 * @Extbase\Validate("NotEmpty")
	 */
	protected $zimmer;


	/**
	 * wohnflache
	 *
	 * @var float
	 * @Extbase\Validate("NotEmpty")
	 */
	protected $wohnflache;

	/**
	 * warmmiete
	 *
	 * @var float
	 * @Extbase\Validate("NotEmpty")
	 */
	protected $warmmiete;

	/**
	 * image
	 *
	 * @var \TYPO3\CMS\Extbase\Domain\Model\FileReference
	 * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade("remove")
	 */
	protected $image = null;

	/**
	 * Returns the name
	 *
	 * @return string $name
	 */
	public function getName() {
		return $this->name;
	}

	/**
	 * Sets the name
	 *
	 * @param string $name
	 * @return void
	 */
	public function setName($name) {
		$this->name = $name;
	}

	/**
	 * Returns the lage
	 *
	 * @return string $lage
	 */
	public function getLage() {
		return $this->lage;
	}

	/**
	 * Sets the lage
	 *
	 * @param string $lage
	 * @return void
	 */
	public function setLage($lage) {
		$this->lage = $lage;
	}

	/**
	 * Returns the zimmer
	 *
	 * @return string $zimmer
	 */
	public function getZimmer() {
		return $this->zimmer;
	}

	/**
	 * Sets the zimmer
	 *
	 * @param string $zimmer
	 * @return void
	 */
	public function setZimmer($zimmer) {
		$this->zimmer = $zimmer;
	}

	/**
	 * Returns the wohnflache
	 *
	 * @return string $wohnflache
	 */
	public function getWohnflache() {
		return $this->wohnflache;
	}

	/**
	 * Sets the wohnflache
	 *
	 * @param string $wohnflache
	 * @return void
	 */
	public function setWohnflache($wohnflache) {
		$this->wohnflache = $wohnflache;
	}

	/**
	 * Returns the warmmiete
	 *
	 * @return string $warmmiete
	 */
	public function getWarmmiete() {
		return $this->warmmiete;
	}

	/**
	 * Sets the warmmiete
	 *
	 * @param string $warmmiete
	 * @return void
	 */
	public function setWarmmiete($warmmiete) {
		$this->warmmiete = $warmmiete;
	}

	/**
	 * Returns the finanzierung
	 *
	 * @return string $finanzierung
	 */
	public function getFinanzierung() {
		return $this->finanzierung;
	}

	/**
	 * Sets the finanzierung
	 *
	 * @param string $finanzierung
	 * @return void
	 */
	public function setFinanzierung($finanzierung) {
		$this->finanzierung = $finanzierung;
	}

	/**
	 * Returns the limits
	 *
	 * @return string $limits
	 */
	public function getLimits() {
		return $this->limits;
	}

	/**
	 * Sets the limits
	 *
	 * @param string $limits
	 * @return void
	 */
	public function setLimits($limits) {
		$this->limits = $limits;
	}

	/**
	 * Returns the image
	 *
	 * @return \TYPO3\CMS\Extbase\Domain\Model\FileReference $image
	 */
	public function getImage()
	{
	    return $this->image;
	}
	/**
	 * Sets the image
	 *
	 * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $image
	 * @return void
	 */
	public function setImage(\TYPO3\CMS\Extbase\Domain\Model\FileReference $image)
	{
	    $this->image = $image;
	}

}