<?php

namespace SG\SgImmobilieList\Controller;

use SG\SgImmobilieList\Domain\Model\Item;
use SG\SgImmobilieList\Domain\Repository\ItemRepository;
use TYPO3\CMS\Core\Cache\CacheManager;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Extbase\Mvc\Exception\NoSuchArgumentException;
use TYPO3\CMS\Extbase\Annotation\Inject;

class DisplayController extends ActionController {

    /**
     * itemRepository
     *
     * @inject
     * @var \SG\SgImmobilieList\Domain\Repository\ItemRepository
     */
    protected $itemRepository;

    /**
     * @var \TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer
     */
    private $contentObj;

    /**
     * @throws NoSuchArgumentException
     */
    public function indexAction() {

        if (empty($_POST['form_send']) || empty($_POST['immobilie_uid'])) {
/*
            $this->contentObj = $this->configurationManager->getContentObject();
            $cache = GeneralUtility::makeInstance(CacheManager::class)->getCache('sgimmobilielist_cache');
            $cacheIdentifier = 'sg-sgimmobilielist-'.$this->contentObj->data['uid'];
            $activeCategory = null;

            if (($entry = $cache->get($cacheIdentifier)) === FALSE) {
*/
                $items = $this->itemRepository->findAll();
                if ($items->count() > 0){
                    $this->view->assign('items', $items);
                }else{
                    $this->view->assign('error',1);
                    $this->view->assign('errorType','NO-ITEMS');
                }

                $this->view->assign('contentObjectUid', $this->contentObj->data['uid']);

                $entry = $this->view->render();

/*
                $tags = array();
                $lifetime = $this->settings['defaultCacheLifetime'];

                // Save value in cache
                $cache->set($cacheIdentifier, $entry, $tags, $lifetime);

            }
*/

            return $entry;

        } else {

            $item = $this->itemRepository->findOneByUid($_POST['immobilie_uid']);
			$item->setLimits($item->getLimits() + 1);
			$res = $this->itemRepository->update($item);

			$this->redirectToUri('/danke');


        }

   }
}