<?php
namespace SG\SgHeadless\Util;

use Doctrine\DBAL\FetchMode;
use TYPO3\CMS\Core\Cache\CacheManager;
use TYPO3\CMS\Core\Configuration\ExtensionConfiguration;
use TYPO3\CMS\Core\Core\Environment;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManager;

class BlogUtil
{

    /**
     * @var ConnectionPool
     */
    private $connectionPool;

    /**
     * @var ConfigurationManager
     */
    protected $configurationManager;

    /**
     * @param ConfigurationManager $configurationManager
     */
    public function injectConfigurationManager(ConfigurationManager $configurationManager)
    {
        $this->configurationManager = $configurationManager;
    }

    public function __construct()
    {
        $this->connectionPool = GeneralUtility::makeInstance(ConnectionPool::class);
    }

    /**
     * @param $value
     * @return mixed
     */
    public function getBlogPosts($pages, $filters = [])
    {
        $blogPosts = [];



        // $queryBuilder = (new ConnectionPool())->getConnectionForTable('pages')->createQueryBuilder();
        // $queryBuilder->select('uid', 'pid', 'slug', 'doktype', 'publish_date', 'crdate', 'abstract', 'description', 'subtitle', 'title', 'og_description', 'og_title', 'seo_title', 'twitter_card', 'twitter_description', 'twitter_title', 'featured_image', 'categories', 'authors')
        //     ->from('pages')
        //     ->where(
        //         $queryBuilder->expr()->eq('doktype', $queryBuilder->createNamedParameter('137')),
        //         $queryBuilder->expr()->eq('pid', $queryBuilder->createNamedParameter($blogSettings['pages']))
        //     )->orderBy('publish_date', 'DESC');
        // $blogPosts = $queryBuilder->execute()->fetchAll(); 1356377

        $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionByName('Default');

        $sql = 'p.uid, p.pid, p.slug, p.doktype, p.publish_date, p.crdate, p.abstract, p.description, p.subtitle, p.title, p.og_description, p.og_title, p.seo_title, p.twitter_card, p.twitter_description, p.twitter_title, p.featured_image, p.categories, p.authors, GROUP_CONCAT(f.identifier SEPARATOR ",") AS images, f.uid AS file_uid, GROUP_CONCAT(sfp.identifier SEPARATOR ",") AS processed_images
            FROM pages AS p ';


		// filter by Category Slug
        if (!empty($filters) && !empty($filters['category'])) {
            $sql .= 'INNER JOIN sys_category_record_mm AS scr ON scr.uid_foreign = p.uid AND scr.tablenames = "pages"
                INNER JOIN sys_category AS sc ON 
                    sc.uid = scr.uid_local AND sc.slug = "'.addslashes($filters['category']).'" ';
        }

		// filter by Author Slug
        if (!empty($filters) && !empty($filters['author'])) {
            $sql .= 'INNER JOIN tx_blog_post_author_mm AS pa ON pa.uid_local = p.uid
                INNER JOIN tx_blog_domain_model_author AS a ON
                    a.uid = pa.uid_foreign AND a.slug = "'.addslashes($filters['author']).'" ';
        }

		// filter by Category Id
        if (!empty($filters) && !empty($filters['categoryId'])) {
            $sql .= 'INNER JOIN sys_category_record_mm AS scr ON
                scr.uid_foreign = p.uid
                AND scr.tablenames = "pages"
                AND scr.uid_local = "'.addslashes($filters['categoryId']).'" ';
        }


        $sql .= 'LEFT JOIN sys_file_reference AS sfr ON sfr.uid_foreign = p.uid AND sfr.fieldname = "featured_image"
            LEFT JOIN sys_file AS f ON f.uid = sfr.uid_local
            LEFT JOIN sys_file_processedfile AS sfp ON sfp.original = sfr.uid_local AND width = 1000 AND height = 500
            WHERE p.doktype = 137 AND p.pid IN ('.addslashes($pages).') AND p.deleted = 0 AND p.hidden = 0
            GROUP BY p.uid
            ORDER BY p.publish_date DESC';

        $blogPosts = $connection->createQueryBuilder()->addSelectLiteral($sql)->execute()->fetchAll();

        $imageTypes = ['images', 'processed_images'];
        foreach ($blogPosts AS $k => $blogPost) {
            foreach ($imageTypes AS $imageType) {
                if (empty($blogPosts[$k][$imageType])) continue;
                $blogPosts[$k][$imageType] = explode(',', $blogPosts[$k][$imageType]);
                foreach ($blogPosts[$k][$imageType] AS $image_key => $image) {
                    if (empty($image)) continue;
                    $blogPosts[$k][$imageType][$image_key] = 'https://headless.zimmer-im-revier.de/fileadmin/'.$image;
                }
            }
        }



        return $blogPosts;
    }
}
