<?php
declare(strict_types = 1);


namespace SG\SgHeadless\Frontend\DataProcessing;

use SG\SgHeadless\Util\BlogUtil;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer;
use TYPO3\CMS\Frontend\ContentObject\DataProcessorInterface;

/**
 * Minimal TypoScript configuration
 * Process Blog data
 *
 * 10 = SG\SgHeadless\Frontend\DataProcessing\BlogProcessor
 *
 *
 * Advanced TypoScript configuration
 * Process Blog data
 *
 * 10 = SG\SgHeadless\Frontend\DataProcessing\BlogProcessor
 * 10 {
 *   fieldName = pi_flexform
 *   as = flexform
 * }
 */
class BlogProcessor implements DataProcessorInterface
{

    /**
     * @param ContentObjectRenderer $cObj The data of the content element or page
     * @param array $contentObjectConfiguration The configuration of Content Object
     * @param array $processorConfiguration The configuration of this processor
     * @param array $processedData Key/value store of processed data (e.g. to be passed to a Fluid View)
     * @return array the processed data as key/value store
     */
    public function process(ContentObjectRenderer $cObj, array $contentObjectConfiguration, array $processorConfiguration, array $processedData)
    {

//        echo '---'.$GLOBALS['TSFE']->id."---<br />\n<br />\n<br />\n"; // current Page

        if (empty($processedData['data'])) return $processedData;

        if (empty($processedData['data']['list_type'])) return $processedData;

        if (!in_array($processedData['data']['list_type'], ['blog_posts', 'blog_category', 'blog_authorposts'])) return $processedData;

        // echo '---'.$cObj->data['list_type']."---<br />\n<br />\n<br />\n";

        $filters = [];

        $parsedUrlPath = explode('/', $_SERVER['REQUEST_URI']);
        if (count($parsedUrlPath) >= 4 && $parsedUrlPath[1] == 'blog' && $parsedUrlPath[2] == 'kategorie') {
            $filters['category'] = $parsedUrlPath[3];
        }


        if (count($parsedUrlPath) >= 5 && $parsedUrlPath[1] == 'blog' && $parsedUrlPath[3] == 'author') {
            $filters['author'] = $parsedUrlPath[4];
        }

        if (!empty($_REQUEST['testerzzzz125'])) {

            // echo "<pre>", print_r($filters), "</pre>";
            // exit();

            //
            // echo "<pre>", print_r($cObj->data), "</pre>";
            // exit();
            // foreach ($cObj->parameters AS $k => $v) {
            // foreach (get_object_vars($cObj) AS $k => $v) {
            //     echo $k."<br />\n";
            //     echo "<pre>", print_r($v), "</pre>";
            // }
            // exit();
        }

        $blogSettings = [];
        $blogPosts = [];
        $blogSettings['uid']            = $processedData['data']['uid'];
        $blogSettings['pid']            = $processedData['data']['pid'];
        $blogSettings['header']            = $processedData['data']['header'];
        $blogSettings['header_layout']    = $processedData['data']['header_layout'];
        $blogSettings['bodytext']        = $processedData['data']['bodytext'];
        $blogSettings['pages']            = $processedData['data']['pages'];
        $blogSettings['list_type']        = $processedData['data']['list_type'];



        // get Author Info
        if (!empty($filters['author'])) {

            $sql = 'a.uid, a.name, a.slug, a.posts, a.title, a.twitter, a.website, a.bio, GROUP_CONCAT(sfp.identifier SEPARATOR ",") AS processed_images
                FROM tx_blog_domain_model_author AS a
                LEFT JOIN sys_file_reference AS sfr ON sfr.uid_foreign = a.uid AND fieldname = "image" AND tablenames = "tx_blog_domain_model_author"
                LEFT JOIN sys_file_processedfile AS sfp ON sfp.original = sfr.uid_local AND width = 72 AND height = 72
                WHERE a.slug = "'.addslashes($filters['author']).'"';
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionByName('Default');
            $blogSettings['author'] = $connection->createQueryBuilder()->addSelectLiteral($sql)->execute()->fetchAll();

            if (!empty($blogSettings['author']) && !empty($blogSettings['author'][0])) {
                $blogSettings['author'] = $blogSettings['author'][0];

                $blogSettings['author']['bio'] = "<p>".str_replace("\r\n", "</p><p>", $blogSettings['author']['bio'])."</p>";
                if (!empty($blogSettings['author']['processed_images'])) {
                    $blogSettings['author']['processed_images'] = explode(',', $blogSettings['author']['processed_images']);
                    foreach ($blogSettings['author']['processed_images'] AS $image_key => $image) {
                        if (empty($image)) continue;
                        $blogSettings['author']['processed_images'][$image_key] = 'https://headless.zimmer-im-revier.de/fileadmin/'.$image;
                    }
                }
            }
        }



        // get Category Info
        if (!empty($filters['category'])) {

            $sql = 'c.slug, c.title, c.uid, c.pid, c.posts, c.items, c.sorting
                FROM sys_category AS c
                WHERE c.slug = "'.addslashes($filters['category']).'"';
            $connection = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionByName('Default');
            $blogSettings['category'] = $connection->createQueryBuilder()->addSelectLiteral($sql)->execute()->fetchAll();
            if (!empty($blogSettings['category']) && !empty($blogSettings['category'][0])) {
                $blogSettings['category'] = $blogSettings['category'][0];
            }
        }



        // get Blog Posts according filters
        $BlogUtil = new BlogUtil();

        // Set the target variable
        $targetVariableName = $cObj->stdWrapValue('as', $processorConfiguration, 'blog');
        $processedData[$targetVariableName] = ['blog_settings' => $blogSettings, 'blog_posts' => $BlogUtil->getBlogPosts($blogSettings['pages'], $filters)];


        return $processedData;


        // // The field name to process
        // $fieldName = $cObj->stdWrapValue('fieldName', $processorConfiguration);
        // if (empty($fieldName)) {
        //     $fieldName = 'pi_flexform';
        // }
        // if (!$processedData['data'][$fieldName]) {
        //     return $processedData;
        // }

    }
}