<?php
namespace SG\SgFaq\Domain\Model;

use TYPO3\CMS\Extbase\Annotation as Extbase;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class Category extends AbstractEntity {

	/**
	 * title
	 *
	 * @var string
	 * @Extbase\Validate("NotEmpty")
	 */
	protected $title;

	/**
	 * items
	 *
	 * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgFaq\Domain\Model\Item>
	 */
	protected $items;

	/**
	 * Returns the title
	 *
	 * @return string $title
	 */
	public function getTitle() {
		return $this->title;
	}

	/**
	 * Sets the title
	 *
	 * @param string $title
	 * @return void
	 */
	public function setTitle($title) {
		$this->title = $title;
	}

	/**
	 * Category constructor.
	 */
	public function __construct() {
		//Do not remove the next line: It would break the functionality
		$this->initStorageObjects();
	}

	/**
	 * @return void
	 */
	protected function initStorageObjects() {
		/**
		 * Do not modify this method!
		 * It will be rewritten on each save in the extension builder
		 * You may modify the constructor of this class instead
		 */
		$this->items = new ObjectStorage();
	}

	/**
	 * @param \SG\SgFaq\Domain\Model\Item $item
	 */
	public function addItem(Item $item) {
		$this->items->attach($item);
	}

	/**
	 * @param \SG\SgFaq\Domain\Model\Item $itemToRemove
	 */
	public function removeItem(Item $itemToRemove) {
		$this->items->detach($itemToRemove);
	}

	/**
	 * Returns the items
	 *
	 * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgFaq\Domain\Model\Item> $items
	 */
	public function getItems() {
		return $this->items;
	}

	/**
	 * Sets the items
	 *
	 * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgFaq\Domain\Model\Item> $items
	 * @return void
	 */
	public function setItems(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $items) {
		$this->items = $items;
	}
}
